/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jsondoclet;

import capital.scalable.restdocs.jsondoclet.ClassDocumentation;
import capital.scalable.restdocs.jsondoclet.DocletAbortException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ExtractDocumentationAsJsonDoclet
extends Standard {
    public static boolean start(RootDoc root) {
        String destinationDir = ExtractDocumentationAsJsonDoclet.destinationDir(root.options());
        ObjectMapper mapper = ExtractDocumentationAsJsonDoclet.createObjectMapper();
        for (ClassDoc classDoc : root.classes()) {
            ClassDocumentation cd = ClassDocumentation.fromClassDoc(classDoc);
            ExtractDocumentationAsJsonDoclet.writeToFile(destinationDir, mapper, classDoc, cd);
        }
        return true;
    }

    private static String destinationDir(String[][] options) {
        for (String[] os : options) {
            String opt = os[0].toLowerCase();
            if (!opt.equals("-d")) continue;
            return os[1];
        }
        return "../generated-javadoc-json";
    }

    private static void writeToFile(String destinationDir, ObjectMapper mapper, ClassDoc classDoc, ClassDocumentation cd) {
        try {
            Path path = ExtractDocumentationAsJsonDoclet.path(destinationDir, classDoc);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                mapper.writerFor(ClassDocumentation.class).writeValue((Writer)writer, (Object)cd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DocletAbortException("Error writing file: " + e);
        }
    }

    private static Path path(String destinationDir, ClassDoc classDoc) throws IOException {
        String packageName = classDoc.containingPackage().name();
        String packageDir = packageName.replace(".", File.separator);
        Path packagePath = Paths.get(packageDir, new String[0]);
        Path path = destinationDir != null ? Paths.get(destinationDir, new String[0]).resolve(packageDir) : packagePath;
        Files.createDirectories(path, new FileAttribute[0]);
        return path.resolve(classDoc.name() + ".json");
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }
}

