/*
 * Decompiled with CFR 0.152.
 */
package care.better.platform.time.temporal;

import care.better.platform.time.OpenEhrDateTimeFormatterContext;
import care.better.platform.time.temporal.OpenEhrField;
import care.better.platform.time.temporal.OpenEhrFieldState;
import care.better.platform.time.temporal.OpenEhrLocalDate;
import care.better.platform.time.temporal.OpenEhrLocalTime;
import care.better.platform.time.temporal.OpenEhrOffsetDateTime;
import care.better.platform.time.temporal.OpenEhrTemporal;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0001%B1\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcare/better/platform/time/temporal/OpenEhrLocalDateTime;", "Lcare/better/platform/time/temporal/OpenEhrTemporal;", "Ljava/time/LocalDateTime;", "", "Ljava/io/Serializable;", "dateTime", "precisionField", "Lcare/better/platform/time/temporal/OpenEhrField;", "fieldStates", "", "Lcare/better/platform/time/temporal/OpenEhrFieldState;", "resolverStyle", "Ljava/time/format/ResolverStyle;", "(Ljava/time/LocalDateTime;Lcare/better/platform/time/temporal/OpenEhrField;Ljava/util/Map;Ljava/time/format/ResolverStyle;)V", "getDateTime", "()Ljava/time/LocalDateTime;", "atOffset", "Lcare/better/platform/time/temporal/OpenEhrOffsetDateTime;", "offset", "Ljava/time/ZoneOffset;", "compareTo", "", "other", "plus", "Ljava/time/temporal/Temporal;", "amountToAdd", "", "unit", "Ljava/time/temporal/TemporalUnit;", "toExactTemporal", "Ljava/time/temporal/TemporalAccessor;", "toLocalDate", "Lcare/better/platform/time/temporal/OpenEhrLocalDate;", "with", "field", "Ljava/time/temporal/TemporalField;", "newValue", "Companion", "ehr-common-time"})
@SourceDebugExtension(value={"SMAP\nOpenEhrLocalDateTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenEhrLocalDateTime.kt\ncare/better/platform/time/temporal/OpenEhrLocalDateTime\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class OpenEhrLocalDateTime
extends OpenEhrTemporal<LocalDateTime>
implements Comparable<OpenEhrLocalDateTime>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalDateTime dateTime;

    public OpenEhrLocalDateTime(@NotNull LocalDateTime dateTime, @NotNull OpenEhrField precisionField, @NotNull Map<OpenEhrField, ? extends OpenEhrFieldState> fieldStates, @NotNull ResolverStyle resolverStyle) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)precisionField), (String)"precisionField");
        Intrinsics.checkNotNullParameter(fieldStates, (String)"fieldStates");
        Intrinsics.checkNotNullParameter((Object)((Object)resolverStyle), (String)"resolverStyle");
        super((Temporal)dateTime, precisionField, fieldStates, resolverStyle);
        this.dateTime = (LocalDateTime)this.getTemporal();
    }

    @NotNull
    public final LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    @NotNull
    public Temporal with(@NotNull TemporalField field2, long newValue) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        LocalDateTime localDateTime = this.dateTime.with(field2, newValue);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"with(...)");
        return new OpenEhrLocalDateTime(localDateTime, this.withTemporalField(field2), this.getFieldStates(), this.getResolverStyle());
    }

    @Override
    @NotNull
    public Temporal plus(long amountToAdd, @NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        LocalDateTime localDateTime = this.dateTime.plus(amountToAdd, unit);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"plus(...)");
        return new OpenEhrLocalDateTime(localDateTime, this.withTemporalUnit(unit), this.getFieldStates(), this.getResolverStyle());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OpenEhrLocalDate toLocalDate() {
        void it;
        OpenEhrField openEhrField;
        LocalDate localDate = this.dateTime.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        OpenEhrField openEhrField2 = openEhrField = this.getPrecisionField();
        LocalDate localDate2 = localDate;
        boolean bl = false;
        boolean bl2 = it.compareTo((Enum)OpenEhrField.DAYS) < 0;
        OpenEhrField openEhrField3 = !bl2 ? openEhrField : null;
        if (openEhrField3 == null) {
            openEhrField3 = OpenEhrField.DAYS;
        }
        ResolverStyle resolverStyle = this.getResolverStyle();
        Map<OpenEhrField, OpenEhrFieldState> map = this.getFieldStates();
        OpenEhrField openEhrField4 = openEhrField3;
        LocalDate localDate3 = localDate2;
        return new OpenEhrLocalDate(localDate3, openEhrField4, map, resolverStyle);
    }

    @Override
    @NotNull
    public TemporalAccessor toExactTemporal() {
        TemporalAccessor temporalAccessor;
        if (this.getPrecisionField() == OpenEhrField.YEARS && !this.isFieldMandatory(OpenEhrField.MONTHS)) {
            Year year = Year.from(this);
            Intrinsics.checkNotNullExpressionValue((Object)year, (String)"from(...)");
            temporalAccessor = year;
        } else if (this.getPrecisionField() == OpenEhrField.MONTHS && !this.isFieldMandatory(OpenEhrField.DAYS)) {
            YearMonth yearMonth = YearMonth.from(this);
            Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"from(...)");
            temporalAccessor = yearMonth;
        } else if (this.getPrecisionField() == OpenEhrField.DAYS && !this.isFieldMandatory(OpenEhrField.HOURS)) {
            LocalDate localDate = LocalDate.from(this);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"from(...)");
            temporalAccessor = localDate;
        } else {
            temporalAccessor = this.getPrecisionField() == OpenEhrField.NANOS ? (TemporalAccessor)this.dateTime : (TemporalAccessor)this;
        }
        return temporalAccessor;
    }

    @NotNull
    public final OpenEhrOffsetDateTime atOffset(@NotNull ZoneOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Integer n = this.dateTime.getMonthValue();
        int n2 = ((Number)n).intValue();
        int n3 = this.dateTime.getYear();
        OpenEhrOffsetDateTime.Companion companion = OpenEhrOffsetDateTime.Companion;
        boolean bl = false;
        boolean bl2 = this.isStrictlySupportedUnit(ChronoUnit.MONTHS);
        Integer n4 = bl2 ? n : null;
        n = this.dateTime.getDayOfMonth();
        int it = ((Number)n).intValue();
        Integer n5 = n4;
        boolean bl3 = false;
        boolean bl4 = this.isStrictlySupportedUnit(ChronoUnit.DAYS);
        Integer n6 = bl4 ? n : null;
        n = this.dateTime.getHour();
        it = ((Number)n).intValue();
        Integer n7 = n6;
        boolean bl5 = false;
        boolean bl6 = this.isStrictlySupportedUnit(ChronoUnit.HOURS);
        Integer n8 = bl6 ? n : null;
        n = this.dateTime.getMinute();
        it = ((Number)n).intValue();
        Integer n9 = n8;
        boolean bl7 = false;
        boolean bl8 = this.isStrictlySupportedUnit(ChronoUnit.MINUTES);
        Integer n10 = bl8 ? n : null;
        n = this.dateTime.getSecond();
        it = ((Number)n).intValue();
        Integer n11 = n10;
        boolean bl9 = false;
        boolean bl10 = this.isStrictlySupportedUnit(ChronoUnit.SECONDS);
        Integer n12 = bl10 ? n : null;
        n = this.dateTime.getNano();
        it = ((Number)n).intValue();
        Integer n13 = n12;
        boolean bl11 = false;
        boolean bl12 = this.isStrictlySupportedUnit(ChronoUnit.NANOS) || this.isStrictlySupportedUnit(ChronoUnit.MICROS) || this.isStrictlySupportedUnit(ChronoUnit.MILLIS);
        return companion.of(n3, n5, n7, n9, n11, n13, bl12 ? n : null, offset, MapsKt.plus(this.getFieldStates(), (Pair)new Pair((Object)OpenEhrField.OFFSET_SECONDS, (Object)OpenEhrFieldState.OPTIONAL)), this.getResolverStyle());
    }

    @Override
    public int compareTo(@NotNull OpenEhrLocalDateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.dateTime.compareTo(other.dateTime);
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrLocalDateTime now() {
        return Companion.now();
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrLocalDateTime now(@NotNull Clock clock) {
        return Companion.now(clock);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano) {
        return Companion.of(year, month, dayOfMonth, hour, minute, second, nano);
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano, @NotNull Map<OpenEhrField, ? extends OpenEhrFieldState> fieldStates, @NotNull ResolverStyle resolverStyle) {
        return Companion.of(year, month, dayOfMonth, hour, minute, second, nano, fieldStates, resolverStyle);
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrLocalDateTime from(@NotNull TemporalAccessor temporal, @NotNull OpenEhrField precisionField, @NotNull OpenEhrDateTimeFormatterContext context) {
        return Companion.from(temporal, precisionField, context);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second) {
        return Companion.of(year, month, dayOfMonth, hour, minute, second);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute) {
        return Companion.of(year, month, dayOfMonth, hour, minute);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour) {
        return Companion.of(year, month, dayOfMonth, hour);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth) {
        return Companion.of(year, month, dayOfMonth);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrLocalDateTime of(int year, @Nullable Integer month) {
        return Companion.of(year, month);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrLocalDateTime of(int year) {
        return Companion.of(year);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J]\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0002\u0010\u0017J{\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcare/better/platform/time/temporal/OpenEhrLocalDateTime$Companion;", "", "()V", "from", "Lcare/better/platform/time/temporal/OpenEhrLocalDateTime;", "temporal", "Ljava/time/temporal/TemporalAccessor;", "precisionField", "Lcare/better/platform/time/temporal/OpenEhrField;", "context", "Lcare/better/platform/time/OpenEhrDateTimeFormatterContext;", "now", "clock", "Ljava/time/Clock;", "of", "year", "", "month", "dayOfMonth", "hour", "minute", "second", "nano", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)Lcare/better/platform/time/temporal/OpenEhrLocalDateTime;", "fieldStates", "", "Lcare/better/platform/time/temporal/OpenEhrFieldState;", "resolverStyle", "Ljava/time/format/ResolverStyle;", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Map;Ljava/time/format/ResolverStyle;)Lcare/better/platform/time/temporal/OpenEhrLocalDateTime;", "ehr-common-time"})
    @SourceDebugExtension(value={"SMAP\nOpenEhrLocalDateTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenEhrLocalDateTime.kt\ncare/better/platform/time/temporal/OpenEhrLocalDateTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OpenEhrLocalDateTime now() {
            Clock clock = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
            return this.now(clock);
        }

        @JvmStatic
        @NotNull
        public final OpenEhrLocalDateTime now(@NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            LocalDateTime localDateTime = LocalDateTime.now(clock);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
            return new OpenEhrLocalDateTime(localDateTime, OpenEhrField.MINIMUM, OpenEhrTemporal.getDefaultFieldStates(OpenEhrField.DATE_TIME_FIELDS), ResolverStyle.SMART);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano) {
            return care.better.platform.time.temporal.OpenEhrLocalDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, minute, second, nano, OpenEhrTemporal.getDefaultFieldStates(OpenEhrField.DATE_TIME_FIELDS), null, 256, null);
        }

        public static /* synthetic */ OpenEhrLocalDateTime of$default(Companion companion, int n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, int n8, Object object) {
            if ((n8 & 2) != 0) {
                n2 = null;
            }
            if ((n8 & 4) != 0) {
                n3 = null;
            }
            if ((n8 & 8) != 0) {
                n4 = null;
            }
            if ((n8 & 0x10) != 0) {
                n5 = null;
            }
            if ((n8 & 0x20) != 0) {
                n6 = null;
            }
            if ((n8 & 0x40) != 0) {
                n7 = null;
            }
            return companion.of(n, n2, n3, n4, n5, n6, n7);
        }

        @JvmStatic
        @NotNull
        public final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano, @NotNull Map<OpenEhrField, ? extends OpenEhrFieldState> fieldStates, @NotNull ResolverStyle resolverStyle) {
            Intrinsics.checkNotNullParameter(fieldStates, (String)"fieldStates");
            Intrinsics.checkNotNullParameter((Object)((Object)resolverStyle), (String)"resolverStyle");
            Integer n = month;
            Integer n2 = dayOfMonth;
            Integer n3 = hour;
            Integer n4 = minute;
            Integer n5 = second;
            Integer n6 = nano;
            LocalDateTime localDateTime = LocalDateTime.of(year, n != null ? n : 1, n2 != null ? n2 : 1, n3 != null ? n3 : 0, n4 != null ? n4 : 0, n5 != null ? n5 : 0, n6 != null ? n6 : 0);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
            OpenEhrField openEhrField = OpenEhrLocalTime.Companion.getPrecision(hour, minute, second, nano);
            if (openEhrField == null) {
                openEhrField = OpenEhrLocalDate.Companion.getPrecision(year, month, dayOfMonth);
            }
            return new OpenEhrLocalDateTime(localDateTime, openEhrField, fieldStates, resolverStyle);
        }

        public static /* synthetic */ OpenEhrLocalDateTime of$default(Companion companion, int n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Map map, ResolverStyle resolverStyle, int n8, Object object) {
            if ((n8 & 2) != 0) {
                n2 = null;
            }
            if ((n8 & 4) != 0) {
                n3 = null;
            }
            if ((n8 & 8) != 0) {
                n4 = null;
            }
            if ((n8 & 0x10) != 0) {
                n5 = null;
            }
            if ((n8 & 0x20) != 0) {
                n6 = null;
            }
            if ((n8 & 0x40) != 0) {
                n7 = null;
            }
            if ((n8 & 0x100) != 0) {
                resolverStyle = ResolverStyle.SMART;
            }
            return companion.of(n, n2, n3, n4, n5, n6, n7, map, resolverStyle);
        }

        @JvmStatic
        @NotNull
        public final OpenEhrLocalDateTime from(@NotNull TemporalAccessor temporal, @NotNull OpenEhrField precisionField, @NotNull OpenEhrDateTimeFormatterContext context) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            Intrinsics.checkNotNullParameter((Object)((Object)precisionField), (String)"precisionField");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (temporal instanceof OpenEhrLocalDateTime) {
                return (OpenEhrLocalDateTime)temporal;
            }
            if (!(temporal.query(TemporalQueries.zone()) == null)) {
                boolean $i$a$-require-OpenEhrLocalDateTime$Companion$from$22 = false;
                String $i$a$-require-OpenEhrLocalDateTime$Companion$from$22 = "temporal";
                throw new IllegalArgumentException($i$a$-require-OpenEhrLocalDateTime$Companion$from$22.toString());
            }
            LocalDateTime it = switch (WhenMappings.$EnumSwitchMapping$0[precisionField.ordinal()]) {
                case 1 -> Year.from(temporal).atDay(1).atStartOfDay();
                case 2 -> YearMonth.from(temporal).atDay(1).atStartOfDay();
                case 3 -> LocalDate.from(temporal).atStartOfDay();
                default -> LocalDateTime.from(temporal);
            };
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            return new OpenEhrLocalDateTime(it, precisionField, context.getPatternFieldStates(), context.getResolverStyle());
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second) {
            return care.better.platform.time.temporal.OpenEhrLocalDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, minute, second, null, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute) {
            return care.better.platform.time.temporal.OpenEhrLocalDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, minute, null, null, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour) {
            return care.better.platform.time.temporal.OpenEhrLocalDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, null, null, null, 112, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrLocalDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth) {
            return care.better.platform.time.temporal.OpenEhrLocalDateTime$Companion.of$default(this, year, month, dayOfMonth, null, null, null, null, 120, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrLocalDateTime of(int year, @Nullable Integer month) {
            return care.better.platform.time.temporal.OpenEhrLocalDateTime$Companion.of$default(this, year, month, null, null, null, null, null, 124, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrLocalDateTime of(int year) {
            return care.better.platform.time.temporal.OpenEhrLocalDateTime$Companion.of$default(this, year, null, null, null, null, null, null, 126, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OpenEhrField.values().length];
                try {
                    nArray[OpenEhrField.YEARS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OpenEhrField.MONTHS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OpenEhrField.DAYS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

