/*
 * Decompiled with CFR 0.152.
 */
package care.better.platform.time.temporal;

import care.better.platform.time.OpenEhrDateTimeFormatterContext;
import care.better.platform.time.temporal.OpenEhrField;
import care.better.platform.time.temporal.OpenEhrFieldState;
import care.better.platform.time.temporal.OpenEhrLocalDate;
import care.better.platform.time.temporal.OpenEhrLocalDateTime;
import care.better.platform.time.temporal.OpenEhrLocalTime;
import care.better.platform.time.temporal.OpenEhrOffsetTime;
import care.better.platform.time.temporal.OpenEhrTemporal;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.ResolverStyle;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0001&B1\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcare/better/platform/time/temporal/OpenEhrOffsetDateTime;", "Lcare/better/platform/time/temporal/OpenEhrTemporal;", "Ljava/time/OffsetDateTime;", "", "Ljava/io/Serializable;", "dateTime", "precisionField", "Lcare/better/platform/time/temporal/OpenEhrField;", "fieldStates", "", "Lcare/better/platform/time/temporal/OpenEhrFieldState;", "resolverStyle", "Ljava/time/format/ResolverStyle;", "(Ljava/time/OffsetDateTime;Lcare/better/platform/time/temporal/OpenEhrField;Ljava/util/Map;Ljava/time/format/ResolverStyle;)V", "getDateTime", "()Ljava/time/OffsetDateTime;", "compareTo", "", "other", "plus", "Ljava/time/temporal/Temporal;", "amountToAdd", "", "unit", "Ljava/time/temporal/TemporalUnit;", "toExactTemporal", "Ljava/time/temporal/TemporalAccessor;", "toLocalDateTime", "Lcare/better/platform/time/temporal/OpenEhrLocalDateTime;", "toOffsetTime", "Lcare/better/platform/time/temporal/OpenEhrOffsetTime;", "with", "field", "Ljava/time/temporal/TemporalField;", "newValue", "withOffsetSameInstant", "offset", "Ljava/time/ZoneOffset;", "Companion", "ehr-common-time"})
@SourceDebugExtension(value={"SMAP\nOpenEhrOffsetDateTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenEhrOffsetDateTime.kt\ncare/better/platform/time/temporal/OpenEhrOffsetDateTime\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class OpenEhrOffsetDateTime
extends OpenEhrTemporal<OffsetDateTime>
implements Comparable<OpenEhrOffsetDateTime>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OffsetDateTime dateTime;

    public OpenEhrOffsetDateTime(@NotNull OffsetDateTime dateTime, @NotNull OpenEhrField precisionField, @NotNull Map<OpenEhrField, ? extends OpenEhrFieldState> fieldStates, @NotNull ResolverStyle resolverStyle) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)precisionField), (String)"precisionField");
        Intrinsics.checkNotNullParameter(fieldStates, (String)"fieldStates");
        Intrinsics.checkNotNullParameter((Object)((Object)resolverStyle), (String)"resolverStyle");
        super((Temporal)dateTime, precisionField, fieldStates, resolverStyle);
        this.dateTime = (OffsetDateTime)this.getTemporal();
    }

    @NotNull
    public final OpenEhrLocalDateTime toLocalDateTime() {
        LocalDateTime localDateTime = this.dateTime.toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        return new OpenEhrLocalDateTime(localDateTime, this.getPrecisionField(), this.getFieldStates(), this.getResolverStyle());
    }

    @NotNull
    public final OpenEhrOffsetTime toOffsetTime() {
        OffsetTime offsetTime = this.dateTime.toOffsetTime();
        Intrinsics.checkNotNullExpressionValue((Object)offsetTime, (String)"toOffsetTime(...)");
        return new OpenEhrOffsetTime(offsetTime, this.getPrecisionField(), this.getFieldStates(), this.getResolverStyle());
    }

    @NotNull
    public final OpenEhrOffsetDateTime withOffsetSameInstant(@NotNull ZoneOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        if (Intrinsics.areEqual((Object)this.dateTime.getOffset(), (Object)offset)) {
            return this;
        }
        LocalDateTime it = this.dateTime.withOffsetSameInstant(offset).toLocalDateTime();
        boolean bl = false;
        OffsetDateTime offsetDateTime = OffsetDateTime.of(it, offset);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"of(...)");
        return new OpenEhrOffsetDateTime(offsetDateTime, this.getPrecisionField(), this.getFieldStates(), this.getResolverStyle());
    }

    @NotNull
    public final OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    @NotNull
    public Temporal with(@NotNull TemporalField field2, long newValue) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        OffsetDateTime offsetDateTime = this.dateTime.with(field2, newValue);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"with(...)");
        return new OpenEhrOffsetDateTime(offsetDateTime, this.withTemporalField(field2), this.getFieldStates(), this.getResolverStyle());
    }

    @Override
    @NotNull
    public Temporal plus(long amountToAdd, @NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        OffsetDateTime offsetDateTime = this.dateTime.plus(amountToAdd, unit);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"plus(...)");
        return new OpenEhrOffsetDateTime(offsetDateTime, this.withTemporalUnit(unit), this.getFieldStates(), this.getResolverStyle());
    }

    @Override
    @NotNull
    public TemporalAccessor toExactTemporal() {
        OpenEhrOffsetDateTime openEhrOffsetDateTime;
        OpenEhrOffsetDateTime it = openEhrOffsetDateTime = this;
        boolean bl = false;
        OpenEhrOffsetDateTime openEhrOffsetDateTime2 = !(this.getPrecisionField() == OpenEhrField.NANOS) ? openEhrOffsetDateTime : null;
        return openEhrOffsetDateTime2 != null ? (TemporalAccessor)openEhrOffsetDateTime2 : (TemporalAccessor)this.dateTime;
    }

    @Override
    public int compareTo(@NotNull OpenEhrOffsetDateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.dateTime.compareTo(other.dateTime);
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrOffsetDateTime now() {
        return Companion.now();
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrOffsetDateTime now(@NotNull Clock clock) {
        return Companion.now(clock);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano, @NotNull ZoneOffset offset) {
        return Companion.of(year, month, dayOfMonth, hour, minute, second, nano, offset);
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano, @NotNull ZoneOffset offset, @NotNull Map<OpenEhrField, ? extends OpenEhrFieldState> fieldStates, @NotNull ResolverStyle resolverStyle) {
        return Companion.of(year, month, dayOfMonth, hour, minute, second, nano, offset, fieldStates, resolverStyle);
    }

    @JvmStatic
    @NotNull
    public static final OpenEhrOffsetDateTime from(@NotNull TemporalAccessor temporal, @NotNull OpenEhrField precisionField, @NotNull OpenEhrDateTimeFormatterContext context) {
        return Companion.from(temporal, precisionField, context);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @NotNull ZoneOffset offset) {
        return Companion.of(year, month, dayOfMonth, hour, minute, second, offset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @NotNull ZoneOffset offset) {
        return Companion.of(year, month, dayOfMonth, hour, minute, offset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @NotNull ZoneOffset offset) {
        return Companion.of(year, month, dayOfMonth, hour, offset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @NotNull ZoneOffset offset) {
        return Companion.of(year, month, dayOfMonth, offset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @NotNull ZoneOffset offset) {
        return Companion.of(year, month, offset);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OpenEhrOffsetDateTime of(int year, @NotNull ZoneOffset offset) {
        return Companion.of(year, offset);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007Je\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019J\u0083\u0001\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006 "}, d2={"Lcare/better/platform/time/temporal/OpenEhrOffsetDateTime$Companion;", "", "()V", "from", "Lcare/better/platform/time/temporal/OpenEhrOffsetDateTime;", "temporal", "Ljava/time/temporal/TemporalAccessor;", "precisionField", "Lcare/better/platform/time/temporal/OpenEhrField;", "context", "Lcare/better/platform/time/OpenEhrDateTimeFormatterContext;", "now", "clock", "Ljava/time/Clock;", "of", "year", "", "month", "dayOfMonth", "hour", "minute", "second", "nano", "offset", "Ljava/time/ZoneOffset;", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/time/ZoneOffset;)Lcare/better/platform/time/temporal/OpenEhrOffsetDateTime;", "fieldStates", "", "Lcare/better/platform/time/temporal/OpenEhrFieldState;", "resolverStyle", "Ljava/time/format/ResolverStyle;", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/time/ZoneOffset;Ljava/util/Map;Ljava/time/format/ResolverStyle;)Lcare/better/platform/time/temporal/OpenEhrOffsetDateTime;", "ehr-common-time"})
    @SourceDebugExtension(value={"SMAP\nOpenEhrOffsetDateTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenEhrOffsetDateTime.kt\ncare/better/platform/time/temporal/OpenEhrOffsetDateTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OpenEhrOffsetDateTime now() {
            Clock clock = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
            return this.now(clock);
        }

        @JvmStatic
        @NotNull
        public final OpenEhrOffsetDateTime now(@NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            OffsetDateTime offsetDateTime = OffsetDateTime.now(clock);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
            return new OpenEhrOffsetDateTime(offsetDateTime, OpenEhrField.MINIMUM, OpenEhrTemporal.getDefaultFieldStates(OpenEhrField.DATE_TIME_FIELDS), ResolverStyle.SMART);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano, @NotNull ZoneOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return care.better.platform.time.temporal.OpenEhrOffsetDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, minute, second, nano, offset, OpenEhrTemporal.getDefaultFieldStates(OpenEhrField.DATE_TIME_FIELDS), null, 512, null);
        }

        public static /* synthetic */ OpenEhrOffsetDateTime of$default(Companion companion, int n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, ZoneOffset zoneOffset, int n8, Object object) {
            if ((n8 & 2) != 0) {
                n2 = null;
            }
            if ((n8 & 4) != 0) {
                n3 = null;
            }
            if ((n8 & 8) != 0) {
                n4 = null;
            }
            if ((n8 & 0x10) != 0) {
                n5 = null;
            }
            if ((n8 & 0x20) != 0) {
                n6 = null;
            }
            if ((n8 & 0x40) != 0) {
                n7 = null;
            }
            return companion.of(n, n2, n3, n4, n5, n6, n7, zoneOffset);
        }

        @JvmStatic
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @Nullable Integer nano, @NotNull ZoneOffset offset, @NotNull Map<OpenEhrField, ? extends OpenEhrFieldState> fieldStates, @NotNull ResolverStyle resolverStyle) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            Intrinsics.checkNotNullParameter(fieldStates, (String)"fieldStates");
            Intrinsics.checkNotNullParameter((Object)((Object)resolverStyle), (String)"resolverStyle");
            Integer n = month;
            Integer n2 = dayOfMonth;
            Integer n3 = hour;
            Integer n4 = minute;
            Integer n5 = second;
            Integer n6 = nano;
            OffsetDateTime offsetDateTime = OffsetDateTime.of(year, n != null ? n : 1, n2 != null ? n2 : 1, n3 != null ? n3 : 0, n4 != null ? n4 : 0, n5 != null ? n5 : 0, n6 != null ? n6 : 0, offset);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"of(...)");
            OpenEhrField openEhrField = OpenEhrLocalTime.Companion.getPrecision(hour, minute, second, nano);
            if (openEhrField == null) {
                openEhrField = OpenEhrLocalDate.Companion.getPrecision(year, month, dayOfMonth);
            }
            return new OpenEhrOffsetDateTime(offsetDateTime, openEhrField, fieldStates, resolverStyle);
        }

        public static /* synthetic */ OpenEhrOffsetDateTime of$default(Companion companion, int n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, ZoneOffset zoneOffset, Map map, ResolverStyle resolverStyle, int n8, Object object) {
            if ((n8 & 2) != 0) {
                n2 = null;
            }
            if ((n8 & 4) != 0) {
                n3 = null;
            }
            if ((n8 & 8) != 0) {
                n4 = null;
            }
            if ((n8 & 0x10) != 0) {
                n5 = null;
            }
            if ((n8 & 0x20) != 0) {
                n6 = null;
            }
            if ((n8 & 0x40) != 0) {
                n7 = null;
            }
            if ((n8 & 0x200) != 0) {
                resolverStyle = ResolverStyle.SMART;
            }
            return companion.of(n, n2, n3, n4, n5, n6, n7, zoneOffset, map, resolverStyle);
        }

        @JvmStatic
        @NotNull
        public final OpenEhrOffsetDateTime from(@NotNull TemporalAccessor temporal, @NotNull OpenEhrField precisionField, @NotNull OpenEhrDateTimeFormatterContext context) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            Intrinsics.checkNotNullParameter((Object)((Object)precisionField), (String)"precisionField");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (temporal instanceof OpenEhrOffsetDateTime) {
                return (OpenEhrOffsetDateTime)temporal;
            }
            if (ZoneOffset.from(temporal) == null) {
                boolean bl = false;
                String string = "temporal";
                throw new IllegalArgumentException(string.toString());
            }
            OffsetDateTime offsetDateTime = OffsetDateTime.from(temporal);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"from(...)");
            return new OpenEhrOffsetDateTime(offsetDateTime, precisionField, context.getPatternFieldStates(), context.getResolverStyle());
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second, @NotNull ZoneOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return care.better.platform.time.temporal.OpenEhrOffsetDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, minute, second, null, offset, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @Nullable Integer minute, @NotNull ZoneOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return care.better.platform.time.temporal.OpenEhrOffsetDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, minute, null, null, offset, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @Nullable Integer hour, @NotNull ZoneOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return care.better.platform.time.temporal.OpenEhrOffsetDateTime$Companion.of$default(this, year, month, dayOfMonth, hour, null, null, null, offset, 112, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @Nullable Integer dayOfMonth, @NotNull ZoneOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return care.better.platform.time.temporal.OpenEhrOffsetDateTime$Companion.of$default(this, year, month, dayOfMonth, null, null, null, null, offset, 120, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @Nullable Integer month, @NotNull ZoneOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return care.better.platform.time.temporal.OpenEhrOffsetDateTime$Companion.of$default(this, year, month, null, null, null, null, null, offset, 124, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OpenEhrOffsetDateTime of(int year, @NotNull ZoneOffset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            return care.better.platform.time.temporal.OpenEhrOffsetDateTime$Companion.of$default(this, year, null, null, null, null, null, null, offset, 126, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

