/*
 * Decompiled with CFR 0.152.
 */
package care.better.platform.time.temporal;

import care.better.platform.time.temporal.OpenEhrField;
import care.better.platform.time.temporal.OpenEhrFieldState;
import care.better.platform.time.temporal.OpenEhrFieldStateHolder;
import care.better.platform.time.temporal.OpenEhrTemporal;
import java.time.DateTimeException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 ,*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0002:\u0001,B1\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020%H&J\b\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lcare/better/platform/time/temporal/OpenEhrTemporal;", "T", "Ljava/time/temporal/Temporal;", "Lcare/better/platform/time/temporal/OpenEhrFieldStateHolder;", "temporal", "precisionField", "Lcare/better/platform/time/temporal/OpenEhrField;", "fieldStates", "", "Lcare/better/platform/time/temporal/OpenEhrFieldState;", "resolverStyle", "Ljava/time/format/ResolverStyle;", "(Ljava/time/temporal/Temporal;Lcare/better/platform/time/temporal/OpenEhrField;Ljava/util/Map;Ljava/time/format/ResolverStyle;)V", "getPrecisionField", "()Lcare/better/platform/time/temporal/OpenEhrField;", "getResolverStyle", "()Ljava/time/format/ResolverStyle;", "getTemporal", "()Ljava/time/temporal/Temporal;", "Ljava/time/temporal/Temporal;", "equals", "", "other", "", "getLong", "", "field", "Ljava/time/temporal/TemporalField;", "hashCode", "", "isStrictlySupported", "openEhrField", "isStrictlySupportedUnit", "unit", "Ljava/time/temporal/TemporalUnit;", "isSupported", "toExactTemporal", "Ljava/time/temporal/TemporalAccessor;", "toString", "", "until", "endExclusive", "withTemporalField", "withTemporalUnit", "Companion", "ehr-common-time"})
@SourceDebugExtension(value={"SMAP\nOpenEhrTemporal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenEhrTemporal.kt\ncare/better/platform/time/temporal/OpenEhrTemporal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,117:1\n288#2,2:118\n288#2,2:121\n1#3:120\n1313#4,2:123\n1313#4,2:125\n*S KotlinDebug\n*F\n+ 1 OpenEhrTemporal.kt\ncare/better/platform/time/temporal/OpenEhrTemporal\n*L\n43#1:118,2\n45#1:121,2\n83#1:123,2\n90#1:125,2\n*E\n"})
public abstract class OpenEhrTemporal<T extends Temporal>
extends OpenEhrFieldStateHolder
implements Temporal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T temporal;
    @NotNull
    private final OpenEhrField precisionField;
    @NotNull
    private final ResolverStyle resolverStyle;

    public OpenEhrTemporal(@NotNull T temporal, @NotNull OpenEhrField precisionField, @NotNull Map<OpenEhrField, ? extends OpenEhrFieldState> fieldStates, @NotNull ResolverStyle resolverStyle) {
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        Intrinsics.checkNotNullParameter((Object)((Object)precisionField), (String)"precisionField");
        Intrinsics.checkNotNullParameter(fieldStates, (String)"fieldStates");
        Intrinsics.checkNotNullParameter((Object)((Object)resolverStyle), (String)"resolverStyle");
        super(fieldStates);
        this.temporal = temporal;
        this.precisionField = precisionField;
        this.resolverStyle = resolverStyle;
    }

    @NotNull
    protected final T getTemporal() {
        return this.temporal;
    }

    @NotNull
    public final OpenEhrField getPrecisionField() {
        return this.precisionField;
    }

    @NotNull
    protected final ResolverStyle getResolverStyle() {
        return this.resolverStyle;
    }

    @Override
    public boolean isSupported(@NotNull TemporalUnit unit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        if (!this.temporal.isSupported(unit)) {
            bl = false;
        } else if (unit instanceof ChronoUnit && ((ChronoUnit)unit).ordinal() >= this.precisionField.getUnit().ordinal()) {
            Object v1;
            block8: {
                Iterable $this$firstOrNull$iv = this.getFieldStates().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    if (!(((OpenEhrField)((Object)it.getKey())).getUnit() == unit)) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            Map.Entry entry = v1;
            OpenEhrFieldState it = entry != null ? (OpenEhrFieldState)((Object)entry.getValue()) : null;
            boolean bl3 = false;
            OpenEhrFieldState openEhrFieldState = it;
            bl = openEhrFieldState != null ? openEhrFieldState.getPossible() : false;
        } else if (this.resolverStyle != ResolverStyle.STRICT) {
            Object v4;
            block9: {
                Iterable $this$firstOrNull$iv = this.getFieldStates().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl4 = false;
                    if (!(((OpenEhrField)((Object)it.getKey())).getUnit() == unit)) continue;
                    v4 = element$iv;
                    break block9;
                }
                v4 = null;
            }
            Map.Entry entry = v4;
            bl = (entry != null ? (OpenEhrFieldState)((Object)entry.getValue()) : null) == OpenEhrFieldState.MANDATORY;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(@NotNull TemporalField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        if (!this.temporal.isSupported(field2)) return false;
        if (!(field2 instanceof ChronoField)) return false;
        if (field2 == ChronoField.OFFSET_SECONDS) {
            if (this.getFieldStates().get((Object)OpenEhrField.OFFSET_SECONDS) == OpenEhrFieldState.FORBIDDEN) return false;
            return true;
        }
        TemporalUnit temporalUnit = ((ChronoField)field2).getBaseUnit();
        Intrinsics.checkNotNull((Object)temporalUnit, (String)"null cannot be cast to non-null type java.time.temporal.ChronoUnit");
        boolean bl = this.isSupported((ChronoUnit)temporalUnit);
        if (!bl) return false;
        return true;
    }

    public final boolean isStrictlySupported(@NotNull OpenEhrField openEhrField) {
        Intrinsics.checkNotNullParameter((Object)((Object)openEhrField), (String)"openEhrField");
        return this.isStrictlySupportedUnit(openEhrField.getUnit());
    }

    public final boolean isStrictlySupportedUnit(@NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return this.temporal.isSupported(unit) && unit instanceof ChronoUnit && ((ChronoUnit)unit).ordinal() >= this.precisionField.getUnit().ordinal();
    }

    @Override
    public long getLong(@NotNull TemporalField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        if (!this.isSupported(field2)) {
            throw new DateTimeException("Unsupported field " + field2);
        }
        return this.temporal.getLong(field2);
    }

    @Override
    public long until(@NotNull Temporal endExclusive, @NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return this.temporal.until(endExclusive, unit);
    }

    @NotNull
    protected final OpenEhrField withTemporalField(@NotNull TemporalField field2) {
        OpenEhrField openEhrField;
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        if (field2 instanceof ChronoField) {
            OpenEhrField openEhrField2;
            OpenEhrField it = openEhrField2 = this.precisionField;
            boolean bl = false;
            TemporalUnit temporalUnit = ((ChronoField)field2).getBaseUnit();
            Intrinsics.checkNotNull((Object)temporalUnit, (String)"null cannot be cast to non-null type java.time.temporal.ChronoUnit");
            openEhrField = !(((ChronoUnit)temporalUnit).ordinal() < it.getUnit().ordinal()) ? openEhrField2 : null;
            if (openEhrField == null) {
                TemporalUnit temporalUnit2 = ((ChronoField)field2).getBaseUnit();
                Intrinsics.checkNotNull((Object)temporalUnit2, (String)"null cannot be cast to non-null type java.time.temporal.ChronoUnit");
                openEhrField = OpenEhrField.Companion.valueOf((ChronoUnit)temporalUnit2);
            }
        } else {
            throw new DateTimeException("Field " + field2 + " must be instance of ChronoField (time value = " + this + ")");
        }
        return openEhrField;
    }

    @NotNull
    public final OpenEhrField withTemporalUnit(@NotNull TemporalUnit unit) {
        OpenEhrField openEhrField;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        if (unit instanceof ChronoUnit) {
            OpenEhrField openEhrField2;
            OpenEhrField it = openEhrField2 = this.precisionField;
            boolean bl = false;
            openEhrField = !(((ChronoUnit)unit).ordinal() < it.getUnit().ordinal()) ? openEhrField2 : null;
            if (openEhrField == null) {
                openEhrField = OpenEhrField.Companion.valueOf((ChronoUnit)unit);
            }
        } else {
            throw new DateTimeException("Unit " + unit + " must be instance of ChronoUnit (time value = " + this + ")");
        }
        return openEhrField;
    }

    @NotNull
    public abstract TemporalAccessor toExactTemporal();

    @NotNull
    public String toString() {
        try {
            OpenEhrField it;
            StringBuilder builder = new StringBuilder();
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.sortedDescending((Sequence)CollectionsKt.asSequence((Iterable)OpenEhrField.DATE_FIELDS)), (Function1)((Function1)new Function1<OpenEhrField, Boolean>(this){
                final /* synthetic */ OpenEhrTemporal<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull OpenEhrField it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return this.this$0.isSupported(it.getField());
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (OpenEhrField)((Object)element$iv);
                boolean bl = false;
                if (it == OpenEhrField.YEARS) {
                    builder.append(this.getLong(it.getField()));
                    continue;
                }
                builder.append("-").append(StringsKt.padStart((String)String.valueOf(this.getLong(it.getField())), (int)2, (char)'0'));
            }
            $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.sortedDescending((Sequence)CollectionsKt.asSequence((Iterable)OpenEhrField.TIME_FIELDS)), (Function1)((Function1)new Function1<OpenEhrField, Boolean>(this){
                final /* synthetic */ OpenEhrTemporal<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull OpenEhrField it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return this.this$0.isSupported(it.getField());
                }
            }));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (OpenEhrField)((Object)element$iv);
                boolean bl = false;
                if (it == OpenEhrField.HOURS) {
                    if (((CharSequence)builder).length() > 0) {
                        builder.append("T");
                    }
                    builder.append(StringsKt.padStart((String)String.valueOf(this.getLong(it.getField())), (int)2, (char)'0'));
                    continue;
                }
                builder.append(":").append(StringsKt.padStart((String)String.valueOf(this.getLong(it.getField())), (int)2, (char)'0'));
            }
            if (this.isSupported(OpenEhrField.OFFSET_SECONDS.getField())) {
                builder.append(this.query(TemporalQueries.zone())).toString();
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Exception e) {
            String string = this.precisionField.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return this.temporal + " [OpenEhr with " + string + " precision]";
        }
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            bl = true;
        } else {
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                bl = false;
            } else {
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type care.better.platform.time.temporal.OpenEhrTemporal<*>");
                bl = Intrinsics.areEqual(this.temporal, ((OpenEhrTemporal)other).temporal) && this.precisionField == ((OpenEhrTemporal)other).precisionField;
            }
        }
        return bl;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.temporal, this.precisionField, this.getFieldStates(), this.resolverStyle};
        return Objects.hash(objectArray);
    }

    @JvmStatic
    @NotNull
    protected static final Map<OpenEhrField, OpenEhrFieldState> getDefaultFieldStates(@NotNull List<? extends OpenEhrField> fields) {
        return Companion.getDefaultFieldStates(fields);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0005\u00a8\u0006\t"}, d2={"Lcare/better/platform/time/temporal/OpenEhrTemporal$Companion;", "", "()V", "getDefaultFieldStates", "", "Lcare/better/platform/time/temporal/OpenEhrField;", "Lcare/better/platform/time/temporal/OpenEhrFieldState;", "fields", "", "ehr-common-time"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        protected final Map<OpenEhrField, OpenEhrFieldState> getDefaultFieldStates(@NotNull List<? extends OpenEhrField> fields) {
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            return MapsKt.toMap((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.sortedDescending((Sequence)CollectionsKt.asSequence((Iterable)fields)), (Function2)getDefaultFieldStates.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

