/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.ImmutableAssertionImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class CentralAuthenticationServiceImpl
implements CentralAuthenticationService,
InitializingBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private TicketRegistry ticketRegistry;
    private AuthenticationManager authenticationManager;
    private UniqueTicketIdGenerator ticketGrantingTicketUniqueTicketIdGenerator;
    private UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator;
    private ExpirationPolicy ticketGrantingTicketExpirationPolicy;
    private ExpirationPolicy serviceTicketExpirationPolicy;

    public void destroyTicketGrantingTicket(String ticketGrantingTicketId) {
        TicketGrantingTicket ticket;
        Assert.notNull((Object)ticketGrantingTicketId);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing ticket [" + ticketGrantingTicketId + "] from registry."));
        }
        if ((ticket = (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Ticket found.  Expiring and then deleting.");
            }
            ticket.expire();
            this.ticketRegistry.deleteTicket(ticketGrantingTicketId);
        }
    }

    public String grantServiceTicket(String ticketGrantingTicketId, Service service, Credentials credentials) throws TicketException {
        Assert.notNull((Object)ticketGrantingTicketId);
        Assert.notNull((Object)service);
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
        if (ticketGrantingTicket == null || ticketGrantingTicket.isExpired()) {
            throw new InvalidTicketException();
        }
        if (credentials != null) {
            try {
                Authentication authentication = this.authenticationManager.authenticate(credentials);
                Principal originalPrincipal = ticketGrantingTicket.getAuthentication().getPrincipal();
                Principal newPrincipal = authentication.getPrincipal();
                if (!newPrincipal.equals(originalPrincipal)) {
                    throw new TicketCreationException();
                }
            }
            catch (AuthenticationException e) {
                throw new TicketCreationException(e);
            }
        }
        ServiceTicket serviceTicket = ticketGrantingTicket.grantServiceTicket(this.serviceTicketUniqueTicketIdGenerator.getNewTicketId("ST"), service, this.serviceTicketExpirationPolicy);
        if (credentials != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"We received a renew=true request, so setting fromNewLogin to true");
            }
            serviceTicket.setFromNewLogin(true);
        }
        this.ticketRegistry.addTicket(serviceTicket);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Granted service ticket [" + serviceTicket.getId() + "] for service [" + service.getId() + "] for user [" + serviceTicket.getGrantingTicket().getAuthentication().getPrincipal().getId() + "]"));
        }
        return serviceTicket.getId();
    }

    public String grantServiceTicket(String ticketGrantingTicketId, Service service) throws TicketException {
        return this.grantServiceTicket(ticketGrantingTicketId, service, null);
    }

    public String delegateTicketGrantingTicket(String serviceTicketId, Credentials credentials) throws TicketException {
        Assert.notNull((Object)serviceTicketId);
        Assert.notNull((Object)credentials);
        try {
            Authentication authentication = this.authenticationManager.authenticate(credentials);
            ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
            if (serviceTicket == null || serviceTicket.isExpired()) {
                throw new InvalidTicketException();
            }
            TicketGrantingTicket ticketGrantingTicket = serviceTicket.grantTicketGrantingTicket(this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, this.ticketGrantingTicketExpirationPolicy);
            this.ticketRegistry.addTicket(ticketGrantingTicket);
            return ticketGrantingTicket.getId();
        }
        catch (AuthenticationException e) {
            throw new TicketCreationException(e);
        }
    }

    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws TicketException {
        Assert.notNull((Object)serviceTicketId);
        Assert.notNull((Object)service);
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ServiceTicket [" + serviceTicketId + "] does not exist."));
            }
            throw new InvalidTicketException();
        }
        if (serviceTicket.isExpired()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ServiceTicket [" + serviceTicketId + "] has expired."));
            }
            this.ticketRegistry.deleteTicket(serviceTicketId);
            throw new InvalidTicketException();
        }
        serviceTicket.incrementCountOfUses();
        serviceTicket.updateLastTimeUsed();
        if (serviceTicket.isExpired()) {
            this.ticketRegistry.deleteTicket(serviceTicketId);
        }
        if (!service.equals(serviceTicket.getService())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ServiceTicket [" + serviceTicketId + "] does not match supplied service."));
            }
            throw new TicketValidationException();
        }
        return new ImmutableAssertionImpl(serviceTicket.getGrantingTicket().getChainedAuthentications(), serviceTicket.getService(), serviceTicket.isFromNewLogin());
    }

    public String createTicketGrantingTicket(Credentials credentials) throws TicketCreationException {
        Assert.notNull((Object)credentials);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attempting to create TicketGrantingTicket for " + credentials));
        }
        try {
            Authentication authentication = this.authenticationManager.authenticate(credentials);
            TicketGrantingTicketImpl ticketGrantingTicket = new TicketGrantingTicketImpl(this.ticketGrantingTicketUniqueTicketIdGenerator.getNewTicketId("TGT"), authentication, this.ticketGrantingTicketExpirationPolicy);
            this.ticketRegistry.addTicket(ticketGrantingTicket);
            return ticketGrantingTicket.getId();
        }
        catch (AuthenticationException e) {
            throw new TicketCreationException(e);
        }
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setTicketGrantingTicketExpirationPolicy(ExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
    }

    public void setTicketGrantingTicketUniqueTicketIdGenerator(UniqueTicketIdGenerator uniqueTicketIdGenerator) {
        this.ticketGrantingTicketUniqueTicketIdGenerator = uniqueTicketIdGenerator;
    }

    public void setServiceTicketExpirationPolicy(ExpirationPolicy serviceTicketExpirationPolicy) {
        this.serviceTicketExpirationPolicy = serviceTicketExpirationPolicy;
    }

    public void afterPropertiesSet() throws Exception {
        String name = this.getClass().getName();
        Assert.notNull((Object)this.ticketRegistry, (String)("ticketRegistry cannot be null on " + name));
        Assert.notNull((Object)this.authenticationManager, (String)("authenticationManager cannot be null on " + name));
        Assert.notNull((Object)this.ticketGrantingTicketUniqueTicketIdGenerator, (String)("ticketGrantingTicketUniqueTicketIdGenerator cannot be null on " + name));
        Assert.notNull((Object)this.serviceTicketUniqueTicketIdGenerator, (String)("serviceTicketUniqueTicketIdGenerator cannot be null on " + name));
        Assert.notNull((Object)this.ticketGrantingTicketExpirationPolicy, (String)("ticketGrantingTicketExpirationPolicy cannot be null on " + name));
        Assert.notNull((Object)this.serviceTicketExpirationPolicy, (String)("serviceTicketExpirationPolicy cannot be null on " + name));
    }

    public void setServiceTicketUniqueTicketIdGenerator(UniqueTicketIdGenerator serviceTicketUniqueTicketIdGenerator) {
        this.serviceTicketUniqueTicketIdGenerator = serviceTicketUniqueTicketIdGenerator;
    }
}

