/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.event;

import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.event.AbstractEvent;

public class HttpRequestEvent
extends AbstractEvent {
    private static final long serialVersionUID = 3257290244557910064L;
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_REFERRER = "Referer";

    public HttpRequestEvent(HttpServletRequest request) {
        super(request);
    }

    public final String getPage() {
        String requestUri = this.getRequest().getRequestURI();
        String requestContext = this.getRequest().getContextPath();
        return requestUri.substring(requestUri.indexOf(requestContext) + requestContext.length() + 1);
    }

    public final String getIpAddress() {
        return this.getRequest().getRemoteAddr();
    }

    public final String getMethod() {
        return this.getRequest().getMethod();
    }

    public final String getUserAgent() {
        return this.getRequest().getHeader(HEADER_USER_AGENT);
    }

    public final String getReferrer() {
        return this.getRequest().getHeader(HEADER_REFERRER);
    }

    public final HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getSource();
    }
}

