/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import org.jasig.cas.util.LongNumericGenerator;

public final class DefaultLongNumericGenerator
implements LongNumericGenerator {
    private static final int MAX_STRING_LENGTH = Long.toString(Long.MAX_VALUE).length();
    private static final int MIN_STRING_LENGTH = 1;
    private static final boolean DEFAULT_WRAP = true;
    private static final long DEFAULT_INTITIAL_VALUE = 0L;
    private boolean wrap;
    private long count = 0L;

    public DefaultLongNumericGenerator() {
        this.wrap = true;
    }

    public DefaultLongNumericGenerator(boolean wrap) {
        this(0L, wrap);
    }

    public DefaultLongNumericGenerator(long initialValue, boolean wrap) {
        this.wrap = wrap;
        this.count = initialValue;
    }

    public DefaultLongNumericGenerator(long initialValue) {
        this(initialValue, true);
    }

    public long getNextLong() {
        return this.getNextValue();
    }

    public String getNextNumberAsString() {
        return Long.toString(this.getNextValue());
    }

    public int maxLength() {
        return MAX_STRING_LENGTH;
    }

    public int minLength() {
        return 1;
    }

    protected synchronized long getNextValue() {
        if (!this.wrap && this.count == Long.MAX_VALUE) {
            throw new IllegalStateException("Maximum value reached for this number generator.");
        }
        if (this.count == Long.MAX_VALUE) {
            this.count = 0L;
        }
        return ++this.count;
    }
}

