/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.SimpleService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.flow.AbstractCasLoginAction;
import org.jasig.cas.web.flow.util.ContextUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;

public abstract class AbstractNonInteractiveCredentialsAction
extends AbstractCasLoginAction {
    protected final Event doExecuteInternal(RequestContext context, String ticketGrantingTicketId, String service, boolean gateway, boolean renew, boolean warn) {
        Credentials credentials;
        block7: {
            credentials = this.constructCredentialsFromRequest(context);
            if (credentials == null) {
                return this.error();
            }
            if (renew && StringUtils.hasText((String)ticketGrantingTicketId) && StringUtils.hasText((String)service)) {
                try {
                    String serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicketId, new SimpleService(service), credentials);
                    ContextUtils.addAttribute(context, "ticket", serviceTicketId);
                    return this.success();
                }
                catch (TicketException e) {
                    if (e.getCause() != null && AuthenticationException.class.isAssignableFrom(e.getCause().getClass())) {
                        return this.error();
                    }
                    this.getCentralAuthenticationService().destroyTicketGrantingTicket(ticketGrantingTicketId);
                    if (!this.logger.isDebugEnabled()) break block7;
                    this.logger.debug((Object)"Attempted to generate a ServiceTicket using renew=true with different credentials", (Throwable)e);
                }
            }
        }
        try {
            String newTicketGrantingTicketId = this.getCentralAuthenticationService().createTicketGrantingTicket(credentials);
            ContextUtils.addAttribute(context, "ticketGrantingTicketId", newTicketGrantingTicketId);
            return this.success();
        }
        catch (TicketException e) {
            return this.error();
        }
    }

    protected abstract Credentials constructCredentialsFromRequest(RequestContext var1);
}

