/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.execution.servlet.ServletEvent;

public final class ContextUtils {
    private ContextUtils() {
    }

    public static HttpServletRequest getHttpServletRequest(RequestContext context) {
        if (context.getSourceEvent() instanceof ServletEvent) {
            return ((ServletEvent)context.getSourceEvent()).getRequest();
        }
        throw new IllegalStateException("Cannot obtain HttpServletRequest from event of type: " + context.getSourceEvent().getClass().getName());
    }

    public static HttpServletResponse getHttpServletResponse(RequestContext context) {
        if (context.getSourceEvent() instanceof ServletEvent) {
            return ((ServletEvent)context.getSourceEvent()).getResponse();
        }
        throw new IllegalStateException("Cannot obtain HttpServletResponse from event of type: " + context.getSourceEvent().getClass().getName());
    }

    public static void addAttribute(RequestContext context, String attributeName, Object attribute) {
        context.getRequestScope().setAttribute(attributeName, attribute);
    }

    public static Object getAttribute(RequestContext context, String attributeName) {
        return context.getRequestScope().getAttribute(attributeName);
    }

    public static void addAttributeToFlowScope(RequestContext context, String attributeName, Object attribute) {
        context.getFlowScope().setAttribute(attributeName, attribute);
    }

    public static Object getAttributeFromFlowScope(RequestContext context, String attributeName) {
        return context.getFlowScope().getAttribute(attributeName);
    }
}

