/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.init;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.DispatcherServlet;

public final class SafeDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String CAUGHT_THROWABLE_KEY = "exceptionCaughtByServlet";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private DispatcherServlet delegate = new DispatcherServlet();
    private boolean initSuccess = true;

    public void init(ServletConfig config) {
        try {
            this.delegate.init(config);
        }
        catch (Throwable t) {
            this.initSuccess = false;
            String message = "SafeDispatcherServlet: \nThe Spring DispatcherServlet we wrap threw on init.\nBut for our having caught this error, the servlet would not have initialized.";
            this.log.fatal((Object)"SafeDispatcherServlet: \nThe Spring DispatcherServlet we wrap threw on init.\nBut for our having caught this error, the servlet would not have initialized.", t);
            System.err.println("SafeDispatcherServlet: \nThe Spring DispatcherServlet we wrap threw on init.\nBut for our having caught this error, the servlet would not have initialized.");
            t.printStackTrace();
            ServletContext context = config.getServletContext();
            context.log("SafeDispatcherServlet: \nThe Spring DispatcherServlet we wrap threw on init.\nBut for our having caught this error, the servlet would not have initialized.", t);
            context.setAttribute(CAUGHT_THROWABLE_KEY, (Object)t);
        }
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (!this.initSuccess) {
            throw new ApplicationContextException("Unable to initialize application context.");
        }
        this.delegate.service(req, resp);
    }
}

