/*
 * Decompiled with CFR 0.152.
 */
package cat.ereza.customactivityoncrash;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;

@SuppressLint(value={"NewApi"})
public class CustomActivityOnCrash {
    public static final String EXTRA_STACK_TRACE = "cat.ereza.customactivityoncrash.EXTRA_STACK_TACE";
    private static final String TAG = "CustomActivityOnCrash";
    private static final String CAOC_HANDLER_PACKAGE_NAME = "cat.ereza.customactivityoncrash";
    private static final String DEFAULT_HANDLER_PACKAGE_NAME = "com.android.internal.os";
    private static final int MAX_STACK_TRACE_SIZE = 131071;
    private static WeakReference<Activity> lastActivityCreated = new WeakReference<Object>(null);
    private static Application application;
    private static boolean isInBackground;

    public static void init(Context context, Class<? extends Activity> errorActivityClass) {
        CustomActivityOnCrash.initInternal(context, errorActivityClass, true);
    }

    public static void init(Context context, Class<? extends Activity> errorActivityClass, boolean startActivityEvenIfInBackground) {
        CustomActivityOnCrash.initInternal(context, errorActivityClass, startActivityEvenIfInBackground);
    }

    private static void initInternal(Context context, final Class<? extends Activity> errorActivityClass, final boolean startActivityEvenIfInBackground) {
        try {
            if (context == null) {
                Log.e((String)TAG, (String)"Initialization failed: context is null!");
            } else if (errorActivityClass == null) {
                Log.e((String)TAG, (String)"Initialization failed: errorActivityClass is null!");
            } else {
                Thread.UncaughtExceptionHandler oldHandler;
                if (Build.VERSION.SDK_INT < 14) {
                    Log.w((String)TAG, (String)"CustomActivityOnCrash will be initialized, but may not be reliable in API lower than 14");
                }
                if ((oldHandler = Thread.getDefaultUncaughtExceptionHandler()) != null && oldHandler.getClass().getName().startsWith(CAOC_HANDLER_PACKAGE_NAME)) {
                    Log.e((String)TAG, (String)"You have already initialized CustomActivityOnCrash, doing nothing!");
                } else {
                    if (oldHandler != null && !oldHandler.getClass().getName().startsWith(DEFAULT_HANDLER_PACKAGE_NAME)) {
                        Log.e((String)TAG, (String)"IMPORTANT WARNING! You already have an UncaughtExceptionHandler, are you sure this is correct? If you use ACRA, Crashlytics or similar libraries, you must initialize them AFTER CustomActivityOnCrash! Initializing anyway, but your original handler will not be called.");
                    }
                    application = (Application)context.getApplicationContext();
                    Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable throwable) {
                            Log.e((String)CustomActivityOnCrash.TAG, (String)"App has crashed, executing CustomActivityOnCrash's UncaughtExceptionHandler", (Throwable)throwable);
                            if (CustomActivityOnCrash.isStackTraceLikelyConflictive(throwable, errorActivityClass)) {
                                Log.e((String)CustomActivityOnCrash.TAG, (String)"Your application class or your error activity have crashed, the custom activity will not be launched!");
                            } else if (startActivityEvenIfInBackground || !isInBackground) {
                                Intent intent = new Intent((Context)application, errorActivityClass);
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                throwable.printStackTrace(pw);
                                String stackTraceString = sw.toString();
                                if (stackTraceString.length() > 131071) {
                                    String disclaimer = " [stack trace too large]";
                                    stackTraceString = stackTraceString.substring(0, 131071 - disclaimer.length()) + disclaimer;
                                }
                                intent.putExtra(CustomActivityOnCrash.EXTRA_STACK_TRACE, stackTraceString);
                                intent.setFlags(0x10000000);
                                application.startActivity(intent);
                            }
                            Activity lastActivity = (Activity)lastActivityCreated.get();
                            if (lastActivity != null) {
                                lastActivity.finish();
                                lastActivityCreated.clear();
                            }
                            Process.killProcess((int)Process.myPid());
                            System.exit(10);
                        }
                    });
                    if (Build.VERSION.SDK_INT >= 14) {
                        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
                            int currentlyStartedActivities = 0;

                            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                                if (activity.getClass() != errorActivityClass) {
                                    lastActivityCreated = new WeakReference<Activity>(activity);
                                }
                            }

                            public void onActivityStarted(Activity activity) {
                                ++this.currentlyStartedActivities;
                                isInBackground = this.currentlyStartedActivities == 0;
                            }

                            public void onActivityResumed(Activity activity) {
                            }

                            public void onActivityPaused(Activity activity) {
                            }

                            public void onActivityStopped(Activity activity) {
                                --this.currentlyStartedActivities;
                                isInBackground = this.currentlyStartedActivities == 0;
                            }

                            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                            }

                            public void onActivityDestroyed(Activity activity) {
                            }
                        });
                    }
                }
                Log.i((String)TAG, (String)"CustomActivityOnCrash has been initialized.");
            }
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"An unknown error occurred when initializing CustomActivityOnCrash, it may not have been properly initialized. Please report this as a bug if needed.", (Throwable)t);
        }
    }

    private static boolean isStackTraceLikelyConflictive(Throwable throwable, Class<? extends Activity> activityClass) {
        do {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = throwable.getStackTrace()) {
                if ((!element.getClassName().equals("android.app.ActivityThread") || !element.getMethodName().equals("handleBindApplication")) && !element.getClassName().equals(activityClass.getName())) continue;
                return true;
            }
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    static {
        isInBackground = false;
    }
}

