/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.ClassUtils;

public class Type {
    public static final Type EMPTY = new Type("", null, null, 0, false);
    public static final Type NULL = new Type("null", null, null, 0, false);
    public static final Type VOID = new Type("void", null, null, 0, false);
    private String name;
    private Collection<Type> arguments;
    private Map<String, Type> bounds;
    private int dimensions;
    private boolean generic;
    private Map<String, Type> typeMap;

    public Type(String string, Collection<Type> collection, Map<String, Type> map, int n, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("name");
        }
        this.name = string;
        this.arguments = collection;
        this.bounds = map;
        this.dimensions = n;
        this.generic = bl;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Collection<String> getImports() {
        Collection<String> collection = this.getImportsInternal();
        collection.remove(this.getName());
        return collection;
    }

    protected Collection<String> getImportsInternal() {
        TreeSet<String> treeSet = new TreeSet<String>();
        this.addImports(treeSet, this.getArguments());
        if (this.getBounds() != null) {
            this.addImports(treeSet, this.getBounds().values());
        }
        return treeSet;
    }

    public Collection<Type> getArguments() {
        return this.arguments == null || this.arguments.isEmpty() ? null : this.arguments;
    }

    public Map<String, Type> getBounds() {
        return this.bounds == null || this.bounds.isEmpty() ? null : this.bounds;
    }

    protected Collection<String> addImports(Collection<String> collection, Collection<? extends Type> collection2) {
        if (collection2 != null) {
            for (Type type : collection2) {
                collection.addAll(type.getImports());
                if (type.getName().indexOf(46) <= -1) continue;
                collection.add(type.getName());
            }
        }
        return collection;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Type> getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap<String, Type>();
        }
        return this.typeMap;
    }

    public void setTypeMap(Map<String, Type> map) {
        this.typeMap = map;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public String toString() {
        return this.getName();
    }

    public Collection<String> getPackageImports() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.getImports()) {
            treeSet.add(ClassUtils.getPackageName((String)string));
        }
        treeSet.remove(this.getNameSpace());
        return treeSet;
    }

    public String getNameSpace() {
        return ClassUtils.getPackageName((String)this.getName());
    }

    public String getQualifiedTypeName() {
        return this.getName();
    }

    public String getTypeName() {
        return ClassUtils.getShortClassName((String)this.getName());
    }
}

