/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.Handler;
import cc.catalysts.cdoclet.handler.TagParser;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractHandler
implements Handler {
    private static final String COMMENT_PREFIX = "\t * ";
    private final Generator generator;

    protected AbstractHandler(Generator generator) {
        this.generator = generator;
    }

    protected Generator getGenerator() {
        return this.generator;
    }

    protected String getBeanPropertyName(String string) {
        String string2 = null;
        if (string.startsWith("set")) {
            string2 = Introspector.decapitalize(string.substring(3));
        } else if (string.startsWith("get")) {
            string2 = Introspector.decapitalize(string.substring(3));
        } else if (string.startsWith("is")) {
            string2 = Introspector.decapitalize(string.substring(2));
        }
        return string2;
    }

    protected void processBeanProperty(ClassDoc classDoc, cc.catalysts.cdoclet.generator.Type type, MethodDoc methodDoc, Set<String> set, Map<String, String> map) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        TagParser.processTags(methodDoc.tags(this.getGenerator().getName() + ".property"), hashMap2);
        hashMap.putAll(hashMap2);
        if (!TagParser.getBooleanCommand("ignore", hashMap) && (string = this.getBeanPropertyName(methodDoc)) != null) {
            String string2 = TagParser.getStringCommand("type", hashMap);
            cc.catalysts.cdoclet.generator.Type type2 = this.getFieldType(methodDoc, this.findField(classDoc, string), string2);
            cc.catalysts.cdoclet.generator.Type type3 = cc.catalysts.cdoclet.generator.Type.EMPTY;
            if (type2 == null) {
                type2 = GeneratorUtils.getType(methodDoc.returnType(), this.getGenerator(), set);
                type3 = GeneratorUtils.getType(methodDoc, this.getGenerator(), set);
            }
            String string3 = methodDoc.name();
            String string4 = methodDoc.commentText();
            if (type2 != cc.catalysts.cdoclet.generator.Type.NULL && (string3.startsWith("get") || string3.startsWith("is"))) {
                String string5 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
                if (classDoc.isInterface()) {
                    this.getGenerator().beginGetter(type, type3, 0, type2, string, string4, false);
                    this.processAnnotations(methodDoc.annotations());
                    this.processAnnotationCommands(hashMap2);
                    this.getGenerator().endGetter();
                    if (this.findMethod(string5, classDoc)) {
                        this.getGenerator().beginSetter(type, type3, 0, type2, string, string4, false);
                        this.processAnnotations(methodDoc.annotations());
                        this.processAnnotationCommands(hashMap2);
                        this.getGenerator().endSetter();
                    }
                } else {
                    boolean bl = this.isOverridden(classDoc, string3, set);
                    this.getGenerator().beginGetter(type, type3, 1, type2, string, string4, bl);
                    this.processAnnotations(methodDoc.annotations());
                    this.processAnnotationCommands(hashMap2);
                    this.getGenerator().endGetter();
                    this.getGenerator().beginSetter(type, type3, 1, type2, string, string4, bl);
                    this.processAnnotations(methodDoc.annotations());
                    this.processAnnotationCommands(hashMap2);
                    this.getGenerator().endSetter();
                }
            }
        }
    }

    private String getBeanPropertyName(MethodDoc methodDoc) {
        String string = null;
        if (methodDoc.parameters().length == 0) {
            string = this.getBeanPropertyName(methodDoc.name());
        }
        return string;
    }

    private cc.catalysts.cdoclet.generator.Type getFieldType(MethodDoc methodDoc, FieldDoc fieldDoc, String string) {
        cc.catalysts.cdoclet.generator.Type type;
        if (string == null) {
            type = this.checkAnnotations(methodDoc.annotations());
            if (type == null && fieldDoc != null) {
                type = this.checkAnnotations(fieldDoc.annotations());
            }
        } else {
            type = GeneratorUtils.getType(string, this.getGenerator());
        }
        return type;
    }

    private cc.catalysts.cdoclet.generator.Type checkAnnotations(AnnotationDesc[] annotationDescArray) {
        AnnotationDesc annotationDesc;
        AnnotationTypeDoc annotationTypeDoc;
        cc.catalysts.cdoclet.generator.Type type = null;
        AnnotationDesc[] annotationDescArray2 = annotationDescArray;
        int n = annotationDescArray2.length;
        for (int i = 0; i < n && (type = GeneratorUtils.getAnnotationType((annotationTypeDoc = (annotationDesc = annotationDescArray2[i]).annotationType()).qualifiedTypeName(), this.getGenerator())) == null; ++i) {
        }
        return type;
    }

    private FieldDoc findField(ClassDoc classDoc, String string) {
        FieldDoc fieldDoc = null;
        for (FieldDoc fieldDoc2 : classDoc.fields(false)) {
            if (!fieldDoc2.name().equals(string)) continue;
            fieldDoc = fieldDoc2;
            break;
        }
        return fieldDoc;
    }

    private boolean findMethod(String string, ClassDoc classDoc) {
        for (MethodDoc methodDoc : classDoc.methods()) {
            if (!string.equals(methodDoc.name())) continue;
            return true;
        }
        return false;
    }

    protected boolean isOverridden(ClassDoc classDoc, String string, Set<String> set) {
        if (classDoc.isInterface()) {
            for (ClassDoc classDoc2 : classDoc.interfaces()) {
                cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType((Type)classDoc2, this.getGenerator(), set);
                if (type == cc.catalysts.cdoclet.generator.Type.NULL) {
                    return false;
                }
                if (set.contains(classDoc2.qualifiedTypeName() + "." + string)) {
                    return false;
                }
                if (set.contains(classDoc2.qualifiedTypeName())) {
                    return false;
                }
                if (this.findMethod(string, classDoc2)) {
                    return true;
                }
                Map<String, String> map = TagParser.processClassTags(this.getGenerator(), classDoc2);
                Set<String> set2 = this.getIgnore(map);
                set2.addAll(set);
                if (!this.isOverridden(classDoc2, string, set2)) continue;
                return true;
            }
        } else {
            for (ClassDoc classDoc3 = classDoc.superclass(); classDoc3 != null; classDoc3 = classDoc3.superclass()) {
                cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType((Type)classDoc3, this.getGenerator(), set);
                if (type == cc.catalysts.cdoclet.generator.Type.NULL) {
                    return false;
                }
                if (set.contains(classDoc3.qualifiedTypeName() + "." + string)) {
                    return false;
                }
                if (set.contains(classDoc3.qualifiedTypeName())) {
                    return false;
                }
                if (this.findMethod(string, classDoc3)) {
                    return true;
                }
                Map<String, String> map = TagParser.processClassTags(this.getGenerator(), classDoc3);
                set.addAll(this.getIgnore(map));
            }
        }
        return false;
    }

    protected Set<String> getIgnore(Map<String, String> map) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(TagParser.getStringCommand("ignore", "", map), ",;");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    protected void processAnnotations(AnnotationDesc[] annotationDescArray) {
        for (AnnotationDesc annotationDesc : annotationDescArray) {
            cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getAnnotation(annotationDesc.annotationType().qualifiedTypeName(), this.getGenerator());
            if (type == null || type == cc.catalysts.cdoclet.generator.Type.NULL) continue;
            this.getGenerator().addAnnotation(type);
        }
    }

    protected void processAnnotationCommands(Map<String, String> map) {
        if (map.containsKey("annotation")) {
            StringTokenizer stringTokenizer = new StringTokenizer(map.get("annotation"), ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.getGenerator().addAnnotation(GeneratorUtils.getType(stringTokenizer.nextToken(), this.getGenerator()));
            }
        }
    }

    protected void processClassComment(ClassDoc classDoc) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = classDoc.commentText();
        if (string != null) {
            stringBuilder.append(string.trim());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\r').append(COMMENT_PREFIX);
            stringBuilder.append('\r').append(COMMENT_PREFIX);
        }
        stringBuilder.append("Generated by CDoclet from ").append(classDoc.qualifiedTypeName()).append('.').append('\r');
        stringBuilder.append(COMMENT_PREFIX).append("Do not edit.");
        this.getGenerator().setTypeDescription(stringBuilder.toString());
    }

    protected void processInterfaces(ClassDoc classDoc, Set<String> set) {
        for (Type type : classDoc.interfaceTypes()) {
            cc.catalysts.cdoclet.generator.Type type2 = GeneratorUtils.getType(type, this.getGenerator(), set);
            if (type2 == cc.catalysts.cdoclet.generator.Type.NULL || set.contains(type2.getName())) continue;
            this.getGenerator().addInterface(type2);
        }
    }
}

