/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import cc.catalysts.cdoclet.handler.TagParser;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ClassHandler
extends AbstractHandler {
    public ClassHandler(Generator generator) {
        super(generator);
    }

    @Override
    public void process(ClassDoc classDoc) {
        Map<String, String> map = TagParser.processClassTags(this.getGenerator(), classDoc);
        Set<String> set = this.getIgnore(map);
        cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), set);
        this.getGenerator().beginClass(type);
        this.processAnnotations(classDoc.annotations());
        this.processAnnotationCommands(map);
        this.processSuperClass(classDoc, set);
        this.processInterfaces(classDoc, set);
        this.processClassComment(classDoc);
        this.processClassConstants(type, classDoc, set);
        this.processBeanProperties(type, classDoc, set, map);
        this.getGenerator().endClass();
    }

    private void processBeanProperties(cc.catalysts.cdoclet.generator.Type type, ClassDoc classDoc, Set<String> set, Map<String, String> map) {
        for (MethodDoc methodDoc : classDoc.methods()) {
            this.processBeanProperty(classDoc, type, methodDoc, set, map);
        }
    }

    private void processClassConstants(cc.catalysts.cdoclet.generator.Type type, ClassDoc classDoc, Collection<String> collection) {
        for (FieldDoc fieldDoc : classDoc.fields()) {
            if (!fieldDoc.isFinal() || !fieldDoc.isPublic()) continue;
            cc.catalysts.cdoclet.generator.Type type2 = GeneratorUtils.getType(fieldDoc.type(), this.getGenerator(), collection);
            this.getGenerator().addConstant(type, type2, fieldDoc.name(), fieldDoc.constantValueExpression(), fieldDoc.commentText());
        }
    }

    private void processSuperClass(ClassDoc classDoc, Collection<String> collection) {
        cc.catalysts.cdoclet.generator.Type type;
        Type type2 = classDoc.superclassType();
        if (type2 != null && !type2.qualifiedTypeName().equals(Object.class.getCanonicalName()) && (type = GeneratorUtils.getType(type2, this.getGenerator(), collection)) != cc.catalysts.cdoclet.generator.Type.NULL && !collection.contains(type.getName())) {
            this.getGenerator().setSuperclass(type, this.isException(classDoc));
        }
    }

    private boolean isException(ClassDoc classDoc) {
        while (classDoc != null) {
            if (Exception.class.getCanonicalName().equals(classDoc.qualifiedTypeName())) {
                return true;
            }
            classDoc = classDoc.superclass();
        }
        return false;
    }
}

