/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumHandler
extends AbstractHandler {
    private final Logger logger = LoggerFactory.getLogger(EnumHandler.class);

    public EnumHandler(Generator generator) {
        super(generator);
    }

    @Override
    public void process(ClassDoc classDoc) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType(classDoc.qualifiedName(), this.getGenerator());
        this.getGenerator().beginEnum(type);
        this.processClassComment(classDoc);
        this.processEnumConstants(type, classDoc);
        this.getGenerator().endEnum();
    }

    private void processEnumConstants(cc.catalysts.cdoclet.generator.Type type, ClassDoc classDoc) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Method method = this.findGetter(classDoc);
        cc.catalysts.cdoclet.generator.Type type2 = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), new HashSet<String>());
        for (FieldDoc fieldDoc : classDoc.enumConstants()) {
            Object object = null;
            if (method != null) {
                Object obj = Enum.valueOf(method.getDeclaringClass(), fieldDoc.name());
                object = method.invoke(obj, new Object[0]);
            }
            this.getGenerator().addEnumField(type, type2, fieldDoc.name(), object, fieldDoc.commentText());
        }
    }

    private Method findGetter(ClassDoc classDoc) throws ClassNotFoundException {
        Class<? extends Annotation> clazz = this.getGenerator().getEnumAnnotation();
        Method method = null;
        if (clazz != null) {
            try {
                Class<?> clazz2 = Class.forName(classDoc.qualifiedName());
                boolean bl = false;
                for (Method method2 : clazz2.getMethods()) {
                    if (!method2.isAnnotationPresent(clazz)) continue;
                    if (bl) {
                        throw new RuntimeException("enumeration " + classDoc + " has multiple annotations");
                    }
                    method = method2;
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logger.error(classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            }
        }
        return method;
    }
}

