/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango;

import cc.concurrent.mango.CacheHandler;
import cc.concurrent.mango.DB;
import cc.concurrent.mango.DataSourceFactory;
import cc.concurrent.mango.MethodStats;
import cc.concurrent.mango.SimpleDataSourceFactory;
import cc.concurrent.mango.exception.IncorrectAnnotationException;
import cc.concurrent.mango.runtime.DataSourceFactoryHolder;
import cc.concurrent.mango.runtime.operator.CacheableOperator;
import cc.concurrent.mango.runtime.operator.Operator;
import cc.concurrent.mango.runtime.operator.OperatorFactory;
import cc.concurrent.mango.runtime.operator.SimpleStatsCounter;
import cc.concurrent.mango.runtime.operator.StatsCounter;
import cc.concurrent.mango.util.ToStringHelper;
import cc.concurrent.mango.util.concurrent.CacheLoader;
import cc.concurrent.mango.util.concurrent.DoubleCheckCache;
import cc.concurrent.mango.util.concurrent.LoadingCache;
import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import cc.concurrent.mango.util.reflect.AbstractInvocationHandler;
import cc.concurrent.mango.util.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.sql.DataSource;

public class Mango {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Mango.class);
    private final DataSourceFactoryHolder dataSourceFactoryHolder;
    private final CacheHandler defaultCacheHandler;
    private final ConcurrentHashMap<Method, StatsCounter> statsCounterMap;

    public Mango(DataSource dataSource) {
        this(new SimpleDataSourceFactory(dataSource));
    }

    public Mango(DataSourceFactory dataSourceFactory) {
        this(dataSourceFactory, null);
    }

    public Mango(DataSource dataSource, CacheHandler defaultCacheHandler) {
        this(new SimpleDataSourceFactory(dataSource), defaultCacheHandler);
    }

    public Mango(DataSourceFactory dataSourceFactory, CacheHandler defaultCacheHandler) {
        this.dataSourceFactoryHolder = new DataSourceFactoryHolder(dataSourceFactory);
        this.defaultCacheHandler = defaultCacheHandler;
        this.statsCounterMap = new ConcurrentHashMap();
    }

    public <T> T create(Class<T> daoClass) {
        return this.create(daoClass, null);
    }

    public <T> T create(Class<T> daoClass, @Nullable CacheHandler cacheHandler) {
        if (daoClass == null) {
            throw new NullPointerException("dao interface can't be null");
        }
        DB dbAnno = daoClass.getAnnotation(DB.class);
        if (dbAnno == null) {
            throw new IncorrectAnnotationException("dao interface expected one cc.concurrent.mango.DB annotation but not found");
        }
        if (cacheHandler == null) {
            cacheHandler = this.defaultCacheHandler;
        }
        return Reflection.newProxy(daoClass, new MangoInvocationHandler(this.dataSourceFactoryHolder, cacheHandler, this.statsCounterMap));
    }

    public Map<Method, MethodStats> getStatsMap() {
        Set<Map.Entry<Method, StatsCounter>> entrySet = this.statsCounterMap.entrySet();
        HashMap<Method, MethodStats> map = new HashMap<Method, MethodStats>();
        for (Map.Entry<Method, StatsCounter> entry : entrySet) {
            map.put(entry.getKey(), entry.getValue().snapshot());
        }
        return map;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactoryHolder.set(dataSourceFactory);
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactoryHolder.get();
    }

    private static class MangoInvocationHandler
    extends AbstractInvocationHandler
    implements InvocationHandler {
        private final DataSourceFactoryHolder dataSourceFactoryHolder;
        private final CacheHandler cacheHandler;
        private final ConcurrentHashMap<Method, StatsCounter> statsCounterMap;
        private final LoadingCache<Method, Operator> cache = new DoubleCheckCache<Method, Operator>(new CacheLoader<Method, Operator>(){

            @Override
            public CacheableOperator load(Method method) throws Exception {
                StatsCounter statsCounter = MangoInvocationHandler.this.getStatusCounter(method);
                long now = System.nanoTime();
                CacheableOperator operator = OperatorFactory.getOperator(method);
                statsCounter.recordInit(System.nanoTime() - now);
                operator.setDataSourceFactoryHolder(MangoInvocationHandler.this.dataSourceFactoryHolder);
                operator.setCacheHandler(MangoInvocationHandler.this.cacheHandler);
                operator.setStatsCounter(statsCounter);
                return operator;
            }
        });

        private MangoInvocationHandler(DataSourceFactoryHolder dataSourceFactoryHolder, @Nullable CacheHandler cacheHandler, ConcurrentHashMap<Method, StatsCounter> statsCounterMap) {
            this.dataSourceFactoryHolder = dataSourceFactoryHolder;
            this.cacheHandler = cacheHandler;
            this.statsCounterMap = statsCounterMap;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (logger.isDebugEnabled()) {
                logger.debug("{} #args={}", (Object)ToStringHelper.toString(method), (Object)args);
            }
            Operator operator = this.cache.get(method);
            Object r = operator.execute(args);
            if (logger.isDebugEnabled()) {
                logger.debug("{} #result={}", (Object)ToStringHelper.toString(method), r);
            }
            return r;
        }

        private StatsCounter getStatusCounter(Method method) {
            StatsCounter old;
            StatsCounter statsCounter = this.statsCounterMap.get(method);
            if (statsCounter == null && (old = this.statsCounterMap.putIfAbsent(method, statsCounter = new SimpleStatsCounter())) != null) {
                statsCounter = old;
            }
            return statsCounter;
        }
    }
}

