/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango;

import javax.annotation.Nullable;

public class MethodStats {
    private final long initCount;
    private final long totalInitTime;
    private final long hitCount;
    private final long missCount;
    private final long executeSuccessCount;
    private final long executeExceptionCount;
    private final long totalExecuteTime;
    private final long evictionCount;

    public MethodStats() {
        this.initCount = 0L;
        this.totalInitTime = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
        this.executeSuccessCount = 0L;
        this.executeExceptionCount = 0L;
        this.totalExecuteTime = 0L;
        this.evictionCount = 0L;
    }

    public MethodStats(long initCount, long totalInitTime, long hitCount, long missCount, long executeSuccessCount, long executeExceptionCount, long totalExecuteTime, long evictionCount) {
        this.initCount = initCount;
        this.totalInitTime = totalInitTime;
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.executeSuccessCount = executeSuccessCount;
        this.executeExceptionCount = executeExceptionCount;
        this.totalExecuteTime = totalExecuteTime;
        this.evictionCount = evictionCount;
    }

    public long averageInitPenalty() {
        return this.initCount == 0L ? 0L : this.totalInitTime / this.initCount;
    }

    public long initCount() {
        return this.initCount;
    }

    public long totalInitTime() {
        return this.totalInitTime;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public long executeCount() {
        return this.executeSuccessCount + this.executeExceptionCount;
    }

    public long executeSuccessCount() {
        return this.executeSuccessCount;
    }

    public double executeSuccessRate() {
        long totalExecuteCount = this.executeSuccessCount + this.executeExceptionCount;
        return totalExecuteCount == 0L ? 1.0 : (double)this.executeSuccessCount / (double)totalExecuteCount;
    }

    public long executeExceptionCount() {
        return this.executeExceptionCount;
    }

    public double executeExceptionRate() {
        long totalExecuteCount = this.executeSuccessCount + this.executeExceptionCount;
        return totalExecuteCount == 0L ? 0.0 : (double)this.executeExceptionCount / (double)totalExecuteCount;
    }

    public long totalExecuteTime() {
        return this.totalExecuteTime;
    }

    public long averageExecutePenalty() {
        long totalExecuteCount = this.executeSuccessCount + this.executeExceptionCount;
        return totalExecuteCount == 0L ? 0L : this.totalExecuteTime / totalExecuteCount;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public MethodStats plus(MethodStats other) {
        return new MethodStats(this.initCount + other.initCount, this.totalInitTime + other.totalInitTime, this.hitCount + other.hitCount, this.missCount + other.missCount, this.executeSuccessCount + other.executeSuccessCount, this.executeExceptionCount + other.executeExceptionCount, this.totalExecuteTime + other.totalExecuteTime, this.evictionCount + other.evictionCount);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof MethodStats) {
            MethodStats other = (MethodStats)object;
            return this.hitCount == other.hitCount && this.missCount == other.missCount && this.executeSuccessCount == other.executeSuccessCount && this.executeExceptionCount == other.executeExceptionCount && this.totalExecuteTime == other.totalExecuteTime && this.evictionCount == other.evictionCount;
        }
        return false;
    }

    public String toString() {
        return String.format("{averageExecutePenalty=%s, executeSuccessCount=%s, executeExceptionCount=%s, totalExecuteTime=%s, hitCount=%s, missCount=%s, evictionCount=%s, averageInitPenalty=%s, initCount=%s, totalInitTime=%s}", this.averageExecutePenalty(), this.executeSuccessCount, this.executeExceptionCount, this.totalExecuteTime, this.hitCount, this.missCount, this.evictionCount, this.averageInitPenalty(), this.initCount, this.totalInitTime);
    }
}

