/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.jdbc;

import cc.concurrent.mango.jdbc.ResultSetExtractor;
import cc.concurrent.mango.jdbc.RowMapper;
import cc.concurrent.mango.util.ArrayUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class ArrayResultSetExtractor<T>
implements ResultSetExtractor<Object> {
    private final RowMapper<T> rowMapper;

    public ArrayResultSetExtractor(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    @Override
    public Object extractData(ResultSet rs) throws SQLException {
        ArrayList<T> list = new ArrayList<T>();
        int rowNum = 0;
        while (rs.next()) {
            list.add(this.rowMapper.mapRow(rs, rowNum++));
        }
        return ArrayUtil.toArray(list, this.rowMapper.getMappedClass());
    }
}

