/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.jdbc;

import cc.concurrent.mango.jdbc.JdbcUtils;
import cc.concurrent.mango.jdbc.RowMapper;
import cc.concurrent.mango.util.Strings;
import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import cc.concurrent.mango.util.reflect.BeanInfoCache;
import cc.concurrent.mango.util.reflect.BeanUtil;
import cc.concurrent.mango.util.reflect.Reflection;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanPropertyRowMapper<T>
implements RowMapper<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BeanPropertyRowMapper.class);
    private Class<T> mappedClass;
    private Map<String, PropertyDescriptor> mappedFields;

    public BeanPropertyRowMapper(Class<T> mappedClass) {
        this.initialize(mappedClass);
    }

    protected void initialize(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        List<PropertyDescriptor> pds = BeanInfoCache.getPropertyDescriptors(mappedClass);
        for (PropertyDescriptor pd : pds) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(pd.getName().toLowerCase(), pd);
            String underscoredName = this.underscoreName(pd.getName());
            if (pd.getName().toLowerCase().equals(underscoredName)) continue;
            this.mappedFields.put(underscoredName, pd);
        }
    }

    private String underscoreName(String name) {
        if (Strings.isNullOrEmpty(name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(name.substring(0, 1).toLowerCase());
        for (int i = 1; i < name.length(); ++i) {
            String slc;
            String s = name.substring(i, i + 1);
            if (!s.equals(slc = s.toLowerCase())) {
                result.append("_").append(slc);
                continue;
            }
            result.append(s);
        }
        return result.toString();
    }

    @Override
    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        T mappedObject = Reflection.instantiate(this.mappedClass);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcUtils.lookupColumnName(rsmd, index);
            PropertyDescriptor pd = this.mappedFields.get(column.trim().toLowerCase());
            if (pd == null) continue;
            Object value = this.getColumnValue(rs, index, pd);
            if (logger.isDebugEnabled() && rowNumber == 0) {
                logger.debug("Mapping column '" + column + "' to property '" + pd.getName() + "' of type " + pd.getPropertyType());
            }
            BeanUtil.setPropertyValue(mappedObject, pd.getName(), value);
        }
        return mappedObject;
    }

    @Override
    public Class<T> getMappedClass() {
        return this.mappedClass;
    }

    protected Object getColumnValue(ResultSet rs, int index, PropertyDescriptor pd) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index, pd.getPropertyType());
    }
}

