/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.jdbc;

import cc.concurrent.mango.exception.ReturnGeneratedKeyException;
import cc.concurrent.mango.exception.UncheckedSQLException;
import cc.concurrent.mango.jdbc.ArrayResultSetExtractor;
import cc.concurrent.mango.jdbc.GeneratedKeyHolder;
import cc.concurrent.mango.jdbc.JdbcUtils;
import cc.concurrent.mango.jdbc.ListResultSetExtractor;
import cc.concurrent.mango.jdbc.ObjectResultSetExtractor;
import cc.concurrent.mango.jdbc.ResultSetExtractor;
import cc.concurrent.mango.jdbc.RowMapper;
import cc.concurrent.mango.jdbc.SetResultSetExtractor;
import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

public class JdbcTemplate {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdbcTemplate.class);

    public <T> T queryForObject(DataSource ds, String sql, Object[] args, RowMapper<T> rowMapper) {
        return this.executeQuery(ds, sql, args, new ObjectResultSetExtractor<T>(rowMapper));
    }

    public <T> List<T> queryForList(DataSource ds, String sql, Object[] args, RowMapper<T> rowMapper) {
        return (List)this.executeQuery(ds, sql, args, new ListResultSetExtractor<T>(rowMapper));
    }

    public <T> Set<T> queryForSet(DataSource ds, String sql, Object[] args, RowMapper<T> rowMapper) {
        return (Set)this.executeQuery(ds, sql, args, new SetResultSetExtractor<T>(rowMapper));
    }

    public <T> Object queryForArray(DataSource ds, String sql, Object[] args, RowMapper<T> rowMapper) {
        return this.executeQuery(ds, sql, args, new ArrayResultSetExtractor<T>(rowMapper));
    }

    public int update(DataSource ds, String sql, Object[] args) {
        return this.update(ds, sql, args, null);
    }

    public int update(DataSource ds, String sql, Object[] args, GeneratedKeyHolder holder) {
        int n;
        Connection conn = JdbcUtils.getConnection(ds);
        PreparedStatement ps = null;
        ResultSet rs = null;
        Integer r = null;
        try {
            boolean needGenerateKey = holder != null;
            ps = needGenerateKey ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this.setValues(ps, args);
            r = ps.executeUpdate();
            if (needGenerateKey) {
                rs = ps.getGeneratedKeys();
                if (!rs.next()) {
                    throw new ReturnGeneratedKeyException("please check whether the table has auto increment key");
                }
                Object key = JdbcUtils.getResultSetValue(rs, 1, holder.getKeyClass());
                holder.setKey(key);
            }
            n = r;
        }
        catch (SQLException e) {
            try {
                throw new UncheckedSQLException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(conn);
                if (logger.isDebugEnabled()) {
                    if (r != null) {
                        logger.debug("\"{}\" #args={} #result={}", sql, args, r);
                    } else {
                        logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)args);
                    }
                }
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(conn);
        if (logger.isDebugEnabled()) {
            if (r != null) {
                logger.debug("\"{}\" #args={} #result={}", sql, args, r);
            } else {
                logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)args);
            }
        }
        return n;
    }

    public int[] batchUpdate(DataSource ds, String sql, List<Object[]> batchArgs) {
        int[] nArray;
        Connection conn = JdbcUtils.getConnection(ds);
        PreparedStatement ps = null;
        int[] r = null;
        try {
            ps = conn.prepareStatement(sql);
            this.setBatchValues(ps, batchArgs);
            nArray = r = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new UncheckedSQLException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(conn);
                if (logger.isDebugEnabled()) {
                    ArrayList<List<Object>> debugBatchArgs = new ArrayList<List<Object>>(batchArgs.size());
                    for (Object[] batchArg : batchArgs) {
                        debugBatchArgs.add(Arrays.asList(batchArg));
                    }
                    if (r != null) {
                        logger.debug("\"{}\" #args={} #result={}", sql, debugBatchArgs, r);
                    } else {
                        logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)debugBatchArgs);
                    }
                }
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(conn);
        if (logger.isDebugEnabled()) {
            ArrayList<List<Object>> debugBatchArgs = new ArrayList<List<Object>>(batchArgs.size());
            for (Object[] batchArg : batchArgs) {
                debugBatchArgs.add(Arrays.asList(batchArg));
            }
            if (r != null) {
                logger.debug("\"{}\" #args={} #result={}", sql, debugBatchArgs, r);
            } else {
                logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)debugBatchArgs);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batchUpdate(DataSource ds, List<String> sqls, List<Object[]> batchArgs) {
        int size = Math.min(sqls.size(), batchArgs.size());
        int[] r = new int[size];
        boolean[] success = new boolean[size];
        Connection conn = JdbcUtils.getConnection(ds);
        try {
            for (int i = 0; i < size; ++i) {
                String sql = sqls.get(i);
                Object[] args = batchArgs.get(i);
                PreparedStatement ps = null;
                try {
                    ps = conn.prepareStatement(sql);
                    this.setValues(ps, args);
                    r[i] = ps.executeUpdate();
                    success[i] = true;
                }
                catch (SQLException e) {
                    try {
                        throw new UncheckedSQLException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeStatement(ps);
                        if (logger.isDebugEnabled()) {
                            if (success[i]) {
                                logger.debug("\"{}\" #args={} #result={}", sql, args, r[i]);
                            } else {
                                logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)args);
                            }
                        }
                        throw throwable;
                    }
                }
                JdbcUtils.closeStatement(ps);
                if (!logger.isDebugEnabled()) continue;
                if (success[i]) {
                    logger.debug("\"{}\" #args={} #result={}", sql, args, r[i]);
                    continue;
                }
                logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)args);
                continue;
            }
        }
        finally {
            JdbcUtils.closeConnection(conn);
        }
        return r;
    }

    private <T> T executeQuery(DataSource ds, String sql, Object[] args, ResultSetExtractor<T> rse) {
        T t;
        Connection conn = JdbcUtils.getConnection(ds);
        PreparedStatement ps = null;
        ResultSet rs = null;
        T r = null;
        boolean success = false;
        try {
            ps = conn.prepareStatement(sql);
            this.setValues(ps, args);
            rs = ps.executeQuery();
            r = rse.extractData(rs);
            success = true;
            t = r;
        }
        catch (SQLException e) {
            try {
                throw new UncheckedSQLException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(conn);
                if (logger.isDebugEnabled()) {
                    if (success) {
                        logger.debug("\"{}\" #args={} #result={}", sql, args, r);
                    } else {
                        logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)args);
                    }
                }
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(conn);
        if (logger.isDebugEnabled()) {
            if (success) {
                logger.debug("\"{}\" #args={} #result={}", sql, args, r);
            } else {
                logger.debug("[error] \"{}\" #args={}", (Object)sql, (Object)args);
            }
        }
        return t;
    }

    private void setValues(PreparedStatement ps, Object[] args) throws SQLException {
        int index = 0;
        for (Object arg : args) {
            JdbcUtils.setParameterValue(ps, ++index, arg);
        }
    }

    private void setBatchValues(PreparedStatement ps, List<Object[]> batchArgs) throws SQLException {
        for (Object[] args : batchArgs) {
            int index = 0;
            for (Object arg : args) {
                JdbcUtils.setParameterValue(ps, ++index, arg);
            }
            ps.addBatch();
        }
    }
}

