/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.jdbc;

import cc.concurrent.mango.exception.CannotGetJdbcConnectionException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;

public class JdbcUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdbcUtils.class);
    private static final Set<Class<?>> singleColumClassSet = new HashSet();

    public static Connection getConnection(DataSource ds) {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", e);
        }
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
                conn = null;
            }
            catch (SQLException e) {
                logger.error("Could not close JDBC Connection", e);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception on closing JDBC Connection", e);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
                stmt = null;
            }
            catch (SQLException e) {
                logger.error("Could not close JDBC Statement", e);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception on closing JDBC Statement", e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
                rs = null;
            }
            catch (SQLException e) {
                logger.error("Could not close JDBC ResultSet", e);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception on closing JDBC ResultSet", e);
            }
        }
    }

    public static Object getResultSetValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        Object value = null;
        boolean wasNullCheck = false;
        if (String.class.equals((Object)requiredType)) {
            value = rs.getString(index);
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals((Object)requiredType)) {
            value = rs.getBoolean(index);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals((Object)requiredType)) {
            value = rs.getByte(index);
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals((Object)requiredType)) {
            value = rs.getShort(index);
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals((Object)requiredType)) {
            value = rs.getInt(index);
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals((Object)requiredType)) {
            value = rs.getLong(index);
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals((Object)requiredType)) {
            value = Float.valueOf(rs.getFloat(index));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals((Object)requiredType) || Number.class.equals((Object)requiredType)) {
            value = rs.getDouble(index);
            wasNullCheck = true;
        } else if (byte[].class.equals((Object)requiredType)) {
            value = rs.getBytes(index);
        } else if (Date.class.equals((Object)requiredType)) {
            value = rs.getDate(index);
        } else if (Time.class.equals((Object)requiredType)) {
            value = rs.getTime(index);
        } else if (Timestamp.class.equals((Object)requiredType) || java.util.Date.class.equals((Object)requiredType)) {
            value = rs.getTimestamp(index);
        } else if (BigDecimal.class.equals((Object)requiredType)) {
            value = rs.getBigDecimal(index);
        } else if (Blob.class.equals((Object)requiredType)) {
            value = rs.getBlob(index);
        } else if (Clob.class.equals((Object)requiredType)) {
            value = rs.getClob(index);
        } else {
            throw new UnreachableCodeException();
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public static void setParameterValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value != null && java.util.Date.class.equals(value.getClass())) {
            ps.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
        } else {
            ps.setObject(index, value);
        }
    }

    public static boolean isSingleColumnClass(Class clazz) {
        return singleColumClassSet.contains(clazz);
    }

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    static {
        singleColumClassSet.add(String.class);
        singleColumClassSet.add(BigDecimal.class);
        singleColumClassSet.add(java.util.Date.class);
        singleColumClassSet.add(byte[].class);
        singleColumClassSet.add(Date.class);
        singleColumClassSet.add(Time.class);
        singleColumClassSet.add(Timestamp.class);
        singleColumClassSet.add(Blob.class);
        singleColumClassSet.add(Clob.class);
        singleColumClassSet.add(Boolean.TYPE);
        singleColumClassSet.add(Byte.TYPE);
        singleColumClassSet.add(Character.TYPE);
        singleColumClassSet.add(Double.TYPE);
        singleColumClassSet.add(Float.TYPE);
        singleColumClassSet.add(Integer.TYPE);
        singleColumClassSet.add(Long.TYPE);
        singleColumClassSet.add(Short.TYPE);
        singleColumClassSet.add(Boolean.class);
        singleColumClassSet.add(Byte.class);
        singleColumClassSet.add(Character.class);
        singleColumClassSet.add(Double.class);
        singleColumClassSet.add(Float.class);
        singleColumClassSet.add(Integer.class);
        singleColumClassSet.add(Long.class);
        singleColumClassSet.add(Short.class);
    }
}

