/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.jdbc;

import cc.concurrent.mango.jdbc.ResultSetExtractor;
import cc.concurrent.mango.jdbc.RowMapper;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectResultSetExtractor<T>
implements ResultSetExtractor<T> {
    private final RowMapper<T> rowMapper;

    public ObjectResultSetExtractor(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    @Override
    public T extractData(ResultSet rs) throws SQLException {
        Class<T> mappedClass = this.rowMapper.getMappedClass();
        if (!mappedClass.isPrimitive()) {
            return rs.next() ? (T)this.rowMapper.mapRow(rs, 1) : null;
        }
        if (!rs.next()) {
            throw new NullPointerException("can't cast null to primitive type " + mappedClass);
        }
        T r = this.rowMapper.mapRow(rs, 1);
        if (r == null) {
            throw new NullPointerException("can't cast null to primitive type " + mappedClass);
        }
        return r;
    }
}

