/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.jdbc;

import cc.concurrent.mango.exception.IncorrectResultSetColumnCountException;
import cc.concurrent.mango.jdbc.JdbcUtils;
import cc.concurrent.mango.jdbc.RowMapper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private Class<T> mappedClass;

    public SingleColumnRowMapper(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSetColumnCountException("incorrect column count, expected 1 but " + nrOfColumns);
        }
        Object result = this.getColumnValue(rs, 1, this.mappedClass);
        return (T)result;
    }

    @Override
    public Class<T> getMappedClass() {
        return this.mappedClass;
    }

    protected Object getColumnValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index, requiredType);
    }
}

