/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.plugin.spring;

import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassPath {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClassPath.class);
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final Set<ClassInfo> classes;

    private ClassPath(Set<ClassInfo> classes) {
        this.classes = classes;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        Scanner scanner = new Scanner();
        for (Map.Entry<URI, ClassLoader> entry : ClassPath.getClassPathEntries(classloader).entrySet()) {
            scanner.scan(entry.getKey(), entry.getValue());
        }
        return new ClassPath(scanner.getClasses());
    }

    public Set<ClassInfo> getTopLevelClasses() {
        HashSet<ClassInfo> topLevelClasses = new HashSet<ClassInfo>();
        for (ClassInfo classInfo : this.classes) {
            if (classInfo.getClassName().indexOf(36) != -1) continue;
            topLevelClasses.add(classInfo);
        }
        return topLevelClasses;
    }

    static Map<URI, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        LinkedHashMap<URI, ClassLoader> entries = new LinkedHashMap<URI, ClassLoader>();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries.putAll(ClassPath.getClassPathEntries(parent));
        }
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            for (URL entry : urlClassLoader.getURLs()) {
                URI uri;
                try {
                    uri = entry.toURI();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                if (entries.containsKey(uri)) continue;
                entries.put(uri, classloader);
            }
        }
        return entries;
    }

    static final class Scanner {
        private final Set<ClassInfo> classes = new HashSet<ClassInfo>();
        private final Set<URI> scannedUris = new HashSet<URI>();

        Scanner() {
        }

        Set<ClassInfo> getClasses() {
            return this.classes;
        }

        void scan(URI uri, ClassLoader classloader) throws IOException {
            if (uri.getScheme().equals("file") && this.scannedUris.add(uri)) {
                this.scanFrom(new File(uri), classloader);
            }
        }

        void scanFrom(File file, ClassLoader classloader) throws IOException {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(file, classloader);
            } else {
                this.scanJar(file, classloader);
            }
        }

        private void scanDirectory(File directory, ClassLoader classloader) throws IOException {
            this.scanDirectory(directory, classloader, "", new HashSet<File>());
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix, Set<File> ancestors) throws IOException {
            File canonical = directory.getCanonicalFile();
            if (ancestors.contains(canonical)) {
                return;
            }
            File[] files = directory.listFiles();
            if (files == null) {
                logger.warn("Cannot read directory " + directory);
                return;
            }
            HashSet<File> newAncestors = new HashSet<File>();
            newAncestors.addAll(ancestors);
            newAncestors.add(canonical);
            for (File f : files) {
                String name = f.getName();
                if (f.isDirectory()) {
                    this.scanDirectory(f, classloader, packagePrefix + name + ".", newAncestors);
                    continue;
                }
                if (!name.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) continue;
                int classNameEnd = name.length() - ClassPath.CLASS_FILE_NAME_EXTENSION.length();
                String className = packagePrefix + name.substring(0, classNameEnd);
                this.classes.add(new ClassInfo(className, classloader));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String resourceName;
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(resourceName = entry.getName()).endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) continue;
                    int classNameEnd = resourceName.length() - ClassPath.CLASS_FILE_NAME_EXTENSION.length();
                    String className = resourceName.substring(0, classNameEnd);
                    this.classes.add(new ClassInfo(className, classloader));
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public static final class ClassInfo {
        private final String className;
        private final ClassLoader loader;

        ClassInfo(String className, ClassLoader loader) {
            this.className = className;
            this.loader = loader;
        }

        public String getPackageName() {
            int lastDot = this.className.lastIndexOf(46);
            return lastDot < 0 ? "" : this.className.substring(0, lastDot);
        }

        public String getClassName() {
            return this.className;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return this.className;
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassInfo) {
                ClassInfo that = (ClassInfo)obj;
                return this.className.equals(that.className) && this.loader == that.loader;
            }
            return false;
        }
    }
}

