/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.plugin.spring;

import cc.concurrent.mango.DB;
import cc.concurrent.mango.plugin.spring.ClassPath;
import cc.concurrent.mango.plugin.spring.MangoBeanFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class MangoBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String DAO_END = "Dao";
    private List<String> packages;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
        for (Class<?> daoClass : this.findMangoDaoClass()) {
            GenericBeanDefinition bf = new GenericBeanDefinition();
            bf.setBeanClassName(daoClass.getName());
            MutablePropertyValues pvs = bf.getPropertyValues();
            pvs.addPropertyValue("daoClass", daoClass);
            bf.setBeanClass(MangoBeanFactory.class);
            bf.setPropertyValues(pvs);
            bf.setLazyInit(false);
            dlbf.registerBeanDefinition(daoClass.getName(), (BeanDefinition)bf);
        }
    }

    private List<Class<?>> findMangoDaoClass() {
        try {
            ClassPath cp = ClassPath.from(MangoBeanFactoryPostProcessor.class.getClassLoader());
            Set<ClassPath.ClassInfo> tlcs = cp.getTopLevelClasses();
            LinkedList mangoDaoClasses = new LinkedList();
            for (ClassPath.ClassInfo info : tlcs) {
                for (String p : this.packages) {
                    Class<?> mangoDaoClass;
                    String className = info.getClassName();
                    if (!className.startsWith(p + ".") || !className.endsWith(DAO_END) || !(mangoDaoClass = info.load()).isInterface() || mangoDaoClass.getAnnotation(DB.class) == null) continue;
                    mangoDaoClasses.add(mangoDaoClass);
                }
            }
            return mangoDaoClasses;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }
}

