/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime;

import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.util.reflect.BeanUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RuntimeContextImpl
implements RuntimeContext {
    private final Map<String, Object> parameterMap;
    private final Map<String, Object> cache;

    public RuntimeContextImpl(Map<String, Object> parameterMap) {
        this.parameterMap = parameterMap;
        this.cache = new HashMap<String, Object>();
    }

    @Override
    public Object getPropertyValue(String parameterName, String propertyPath) {
        String key = this.getCacheKey(parameterName, propertyPath);
        Object cachedValue = this.cache.get(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Object object = this.parameterMap.get(parameterName);
        Object value = !propertyPath.isEmpty() ? BeanUtil.getPropertyValue(object, propertyPath, parameterName) : object;
        this.cache.put(key, value);
        return value;
    }

    @Override
    @Nullable
    public Object getNullablePropertyValue(String parameterName, String propertyPath) {
        String key = this.getCacheKey(parameterName, propertyPath);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        Object object = this.parameterMap.get(parameterName);
        Object value = !propertyPath.isEmpty() ? BeanUtil.getNullablePropertyValue(object, propertyPath, parameterName) : object;
        this.cache.put(key, value);
        return value;
    }

    @Override
    public void setPropertyValue(String parameterName, String propertyPath, Object value) {
        String key = this.getCacheKey(parameterName, propertyPath);
        this.cache.put(key, value);
    }

    private String getCacheKey(String parameterName, String propertyPath) {
        return propertyPath.isEmpty() ? parameterName : parameterName + "." + propertyPath;
    }
}

