/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime;

import cc.concurrent.mango.exception.NotReadableParameterException;
import cc.concurrent.mango.runtime.TypeContext;
import cc.concurrent.mango.util.reflect.TypeUtil;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class TypeContextImpl
implements TypeContext {
    private final Map<String, Type> parameterTypeMap;
    private final Map<String, Type> cache;

    public TypeContextImpl(Map<String, Type> parameterTypeMap) {
        this.parameterTypeMap = parameterTypeMap;
        this.cache = new HashMap<String, Type>();
    }

    @Override
    public Type getPropertyType(String parameterName, String propertyPath) {
        String key = this.getCacheKey(parameterName, propertyPath);
        Type cachedType = this.cache.get(key);
        if (cachedType != null) {
            return cachedType;
        }
        Type parameterType = this.parameterTypeMap.get(parameterName);
        if (parameterType == null) {
            throw new NotReadableParameterException("parameter :" + parameterName + " is not readable");
        }
        Type type = !propertyPath.isEmpty() ? TypeUtil.getPropertyType(parameterType, parameterName, propertyPath) : parameterType;
        this.cache.put(key, type);
        return type;
    }

    private String getCacheKey(String parameterName, String propertyPath) {
        return propertyPath.isEmpty() ? parameterName : parameterName + "." + propertyPath;
    }
}

