/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.operator;

import cc.concurrent.mango.DB;
import cc.concurrent.mango.DataSourceFactory;
import cc.concurrent.mango.DataSourceRouter;
import cc.concurrent.mango.IgnoreDataSourceRouter;
import cc.concurrent.mango.IgnoreTablePartition;
import cc.concurrent.mango.Rename;
import cc.concurrent.mango.ShardBy;
import cc.concurrent.mango.TablePartition;
import cc.concurrent.mango.exception.IncorrectAnnotationException;
import cc.concurrent.mango.exception.IncorrectDefinitionException;
import cc.concurrent.mango.exception.IncorrectParameterTypeException;
import cc.concurrent.mango.jdbc.JdbcTemplate;
import cc.concurrent.mango.runtime.DataSourceFactoryHolder;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.RuntimeContextImpl;
import cc.concurrent.mango.runtime.TypeContext;
import cc.concurrent.mango.runtime.TypeContextImpl;
import cc.concurrent.mango.runtime.operator.Operator;
import cc.concurrent.mango.runtime.operator.SQLType;
import cc.concurrent.mango.runtime.operator.StatsCounter;
import cc.concurrent.mango.runtime.parser.ASTRootNode;
import cc.concurrent.mango.util.Strings;
import cc.concurrent.mango.util.ToStringHelper;
import cc.concurrent.mango.util.TypeToken;
import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import cc.concurrent.mango.util.reflect.Reflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.sql.DataSource;

public abstract class AbstractOperator
implements Operator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractOperator.class);
    protected final JdbcTemplate jdbcTemplate = new JdbcTemplate();
    private DataSourceFactoryHolder dataSourceFactoryHolder;
    protected StatsCounter statsCounter;
    private String dataSourceName;
    private String table;
    private TablePartition tablePartition;
    private DataSourceRouter dataSourceRouter;
    private String shardParameterName;
    private String shardPropertyPath;
    protected ASTRootNode rootNode;
    protected Method method;
    protected SQLType sqlType;
    private TypeContext typeContext;
    private String[] aliases;

    protected AbstractOperator(ASTRootNode rootNode, Method method, SQLType sqlType) {
        this.rootNode = rootNode;
        this.method = method;
        this.sqlType = sqlType;
        this.init();
        this.dbInitPostProcessor();
    }

    @Override
    public void setDataSourceFactoryHolder(DataSourceFactoryHolder dataSourceFactoryHolder) {
        this.dataSourceFactoryHolder = dataSourceFactoryHolder;
    }

    @Override
    public void setStatsCounter(StatsCounter statsCounter) {
        this.statsCounter = statsCounter;
    }

    protected RuntimeContext buildRuntimeContext(Object[] methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < methodArgs.length; ++i) {
            parameters.put(this.getParameterNameByIndex(i), methodArgs[i]);
        }
        return new RuntimeContextImpl(parameters);
    }

    protected DataSource getDataSource(RuntimeContext context) {
        return this.getDataSource(this.getDataSourceName(context));
    }

    protected DataSource getDataSource(String dsn) {
        DataSourceFactory dataSourceFactory = this.dataSourceFactoryHolder.get();
        DataSource ds = dataSourceFactory.getDataSource(dsn, this.sqlType);
        if (ds == null) {
            throw new IncorrectDefinitionException("can't find datasource for name " + dsn);
        }
        return ds;
    }

    @Nullable
    protected String getDataSourceName(RuntimeContext context) {
        String dsn = this.dataSourceRouter != null ? this.dataSourceRouter.getDataSourceName(context.getPropertyValue(this.shardParameterName, this.shardPropertyPath)) : this.dataSourceName;
        return dsn;
    }

    protected String getParameterNameByIndex(int index) {
        String alias = this.aliases[index];
        return alias != null ? alias : String.valueOf(index + 1);
    }

    protected TypeContext getTypeContext() {
        if (this.typeContext == null) {
            this.typeContext = this.doGetTypeContext();
        }
        return this.typeContext;
    }

    private void init() {
        this.configDb();
        this.alias();
        this.shardBy();
        this.rootNode.init(this.table, this.tablePartition, this.shardParameterName, this.shardPropertyPath);
        if (logger.isInfoEnabled()) {
            String staticSql = this.rootNode.getStaticSql();
            if (staticSql != null) {
                logger.info("{} build a static sql \"{}\"", (Object)ToStringHelper.toString(this.method), (Object)staticSql);
            } else {
                logger.info("{} can't build static sql", (Object)ToStringHelper.toString(this.method));
            }
        }
        this.rootNode.checkType(this.getTypeContext());
    }

    private void alias() {
        Annotation[][] pass = this.method.getParameterAnnotations();
        this.aliases = new String[pass.length];
        for (int i = 0; i < pass.length; ++i) {
            Annotation[] pas;
            for (Annotation pa : pas = pass[i]) {
                if (!Rename.class.equals(pa.annotationType())) continue;
                this.aliases[i] = ((Rename)pa).value();
            }
        }
    }

    private void shardBy() {
        Type shardType;
        TypeToken typeToken;
        Class<?> mappedClass;
        Annotation[][] pass = this.method.getParameterAnnotations();
        int num = 0;
        for (int i = 0; i < pass.length; ++i) {
            Annotation[] pas;
            for (Annotation pa : pas = pass[i]) {
                if (!ShardBy.class.equals(pa.annotationType())) continue;
                this.shardParameterName = this.getParameterNameByIndex(i);
                this.shardPropertyPath = ((ShardBy)pa).value();
                ++num;
            }
        }
        if (this.tablePartition != null && num != 1) {
            throw new IncorrectDefinitionException("if @DB.tablePartition is defined, need one and only one @ShardBy on method's parameter");
        }
        if (num == 1 && ((mappedClass = (typeToken = new TypeToken(shardType = this.getTypeContext().getPropertyType(this.shardParameterName, this.shardPropertyPath))).getMappedClass()) == null || typeToken.isIterable())) {
            throw new IncorrectParameterTypeException("the type of parameter Modified @ShardBy is error, type is " + shardType);
        }
    }

    private void configDb() {
        Class<? extends DataSourceRouter> dsrc;
        Class<? extends TablePartition> tpc;
        DB dbAnno = this.method.getDeclaringClass().getAnnotation(DB.class);
        if (dbAnno == null) {
            throw new IncorrectAnnotationException("need @DB on dao interface");
        }
        this.dataSourceName = dbAnno.dataSource();
        if (!Strings.isNullOrEmpty(dbAnno.table())) {
            this.table = dbAnno.table();
        }
        if ((tpc = dbAnno.tablePartition()) != null && !tpc.equals(IgnoreTablePartition.class)) {
            this.tablePartition = Reflection.instantiate(tpc);
        }
        if ((dsrc = dbAnno.dataSourceRouter()) != null && !dsrc.equals(IgnoreDataSourceRouter.class)) {
            this.dataSourceRouter = Reflection.instantiate(dsrc);
        }
        if (this.tablePartition != null && this.table == null) {
            throw new IncorrectDefinitionException("if @DB.tablePartition is defined, @DB.table must be defined");
        }
        if (this.dataSourceRouter != null && this.tablePartition == null) {
            throw new IncorrectDefinitionException("if @DB.dataSourceRouter is defined, @DB.tablePartition must be defined");
        }
    }

    private TypeContext doGetTypeContext() {
        Type[] methodArgTypes = this.getMethodArgTypes(this.method);
        HashMap<String, Type> parameterTypeMap = new HashMap<String, Type>();
        for (int i = 0; i < methodArgTypes.length; ++i) {
            parameterTypeMap.put(this.getParameterNameByIndex(i), methodArgTypes[i]);
        }
        return new TypeContextImpl(parameterTypeMap);
    }

    protected void dbInitPostProcessor() {
    }

    abstract Type[] getMethodArgTypes(Method var1);
}

