/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.operator;

import cc.concurrent.mango.exception.IncorrectParameterCountException;
import cc.concurrent.mango.exception.IncorrectParameterTypeException;
import cc.concurrent.mango.exception.IncorrectSqlException;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.operator.CacheableOperator;
import cc.concurrent.mango.runtime.operator.SQLType;
import cc.concurrent.mango.runtime.parser.ASTIterableParameter;
import cc.concurrent.mango.runtime.parser.ASTRootNode;
import cc.concurrent.mango.util.Iterables;
import cc.concurrent.mango.util.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class BatchUpdateOperator
extends CacheableOperator {
    public BatchUpdateOperator(ASTRootNode rootNode, Method method, SQLType sqlType) {
        super(rootNode, method, sqlType);
    }

    @Override
    Type[] getMethodArgTypes(Method method) {
        if (method.getGenericParameterTypes().length != 1) {
            throw new IncorrectParameterCountException("batch update expected one and only one parameter but " + method.getGenericParameterTypes().length);
        }
        Type type = method.getGenericParameterTypes()[0];
        TypeToken typeToken = new TypeToken(type);
        Class<?> mappedClass = typeToken.getMappedClass();
        if (mappedClass == null || !typeToken.isIterable()) {
            throw new IncorrectParameterTypeException("parameter of batch update expected array or implementations of java.util.List or implementations of java.util.Set but " + type);
        }
        return new Type[]{mappedClass};
    }

    @Override
    protected void dbInitPostProcessor() {
        List<ASTIterableParameter> ips = this.rootNode.getIterableParameters();
        if (ips.size() > 0) {
            throw new IncorrectSqlException("if use batch update, sql's in clause number expected 0 but " + ips.size());
        }
    }

    @Override
    public Object execute(Object[] methodArgs) {
        Object methodArg = methodArgs[0];
        if (methodArg == null) {
            throw new NullPointerException("batchUpdate's parameter can't be null");
        }
        Iterables iterables = new Iterables(methodArg);
        if (iterables.isEmpty()) {
            throw new IllegalArgumentException("batchUpdate's parameter can't be empty");
        }
        HashSet<String> keys = null;
        if (this.isUseCache()) {
            keys = new HashSet<String>(iterables.size() * 2);
        }
        HashMap<String, Group> gorupMap = new HashMap<String, Group>();
        for (Object obj : iterables) {
            String dataSourceName;
            Group group;
            RuntimeContext context = this.buildRuntimeContext(new Object[]{obj});
            if (keys != null) {
                keys.add(this.getCacheKey(context));
            }
            if ((group = (Group)gorupMap.get(dataSourceName = this.getDataSourceName(context))) == null) {
                group = new Group();
                gorupMap.put(dataSourceName, group);
            }
            String sql = this.rootNode.getSql(context);
            Object[] args = this.rootNode.getArgs(context);
            group.add(sql, args);
        }
        int[] ints = this.executeDb(gorupMap);
        if (keys != null) {
            this.deleteFromCache(keys);
        }
        return ints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeDb(Map<String, Group> gorupMap) {
        int[] ints = null;
        long now = System.nanoTime();
        try {
            for (Map.Entry<String, Group> entry : gorupMap.entrySet()) {
                DataSource ds = this.getDataSource(entry.getKey());
                List<String> sqls = entry.getValue().getSqls();
                List<Object[]> batchArgs = entry.getValue().getBatchArgs();
                ints = this.isUniqueSql(sqls) ? this.jdbcTemplate.batchUpdate(ds, sqls.get(0), batchArgs) : this.jdbcTemplate.batchUpdate(ds, sqls, batchArgs);
            }
        }
        finally {
            long cost = System.nanoTime() - now;
            if (ints != null) {
                this.statsCounter.recordExecuteSuccess(cost);
            } else {
                this.statsCounter.recordExecuteException(cost);
            }
        }
        return ints;
    }

    private boolean isUniqueSql(List<String> sqls) {
        String sql = sqls.get(0);
        boolean r = true;
        for (int i = 1; i < sqls.size(); ++i) {
            if (sql.equals(sqls.get(i))) continue;
            r = false;
            break;
        }
        return r;
    }

    private static class Group {
        private List<String> sqls = new LinkedList<String>();
        private List<Object[]> batchArgs = new LinkedList<Object[]>();

        private Group() {
        }

        public void add(String sql, Object[] args) {
            this.sqls.add(sql);
            this.batchArgs.add(args);
        }

        public List<String> getSqls() {
            return this.sqls;
        }

        public List<Object[]> getBatchArgs() {
            return this.batchArgs;
        }
    }
}

