/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.operator;

import cc.concurrent.mango.Cache;
import cc.concurrent.mango.CacheBy;
import cc.concurrent.mango.CacheExpire;
import cc.concurrent.mango.CacheHandler;
import cc.concurrent.mango.CacheIgnored;
import cc.concurrent.mango.exception.IncorrectAnnotationException;
import cc.concurrent.mango.exception.IncorrectCacheByException;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.operator.AbstractOperator;
import cc.concurrent.mango.runtime.operator.Cacheable;
import cc.concurrent.mango.runtime.operator.SQLType;
import cc.concurrent.mango.runtime.parser.ASTRootNode;
import cc.concurrent.mango.runtime.parser.ValuableParameter;
import cc.concurrent.mango.util.Iterables;
import cc.concurrent.mango.util.TypeToken;
import cc.concurrent.mango.util.reflect.Reflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class CacheableOperator
extends AbstractOperator
implements Cacheable {
    private CacheHandler cacheHandler;
    private boolean useCache;
    private String prefix;
    private CacheExpire cacheExpire;
    private int expireNum;
    private String suffixParameterName;
    private String suffixPropertyPath;
    private boolean useMultipleKeys;
    private Class<?> suffixClass;

    protected CacheableOperator(ASTRootNode rootNode, Method method, SQLType sqlType) {
        super(rootNode, method, sqlType);
        this.init();
        this.cacheInitPostProcessor();
    }

    @Override
    public void setCacheHandler(@Nullable CacheHandler cacheHandler) {
        if (this.isUseCache() && cacheHandler == null) {
            throw new NullPointerException("if use cache, please provide an implementation of CacheHandler");
        }
        this.cacheHandler = cacheHandler;
    }

    protected boolean isUseCache() {
        return this.useCache;
    }

    protected boolean isUseMultipleKeys() {
        return this.useMultipleKeys;
    }

    protected void setToCache(String key, Object value) {
        this.cacheHandler.set(key, value, this.cacheExpire.getExpireTime() * this.expireNum);
    }

    protected void deleteFromCache(String key) {
        this.cacheHandler.delete(key);
        this.statsCounter.recordEviction(1);
    }

    protected void deleteFromCache(Set<String> keys) {
        if (keys.size() > 0) {
            this.cacheHandler.delete(keys);
            this.statsCounter.recordEviction(keys.size());
        }
    }

    protected Object getFromCache(String key) {
        Object value = this.cacheHandler.get(key);
        if (value != null) {
            this.statsCounter.recordHits(1);
        } else {
            this.statsCounter.recordMisses(1);
        }
        return value;
    }

    protected Map<String, Object> getBulkFromCache(Set<String> keys) {
        if (keys.size() > 0) {
            Map<String, Object> values = this.cacheHandler.getBulk(keys);
            int hitCount = values.size();
            int missCount = keys.size() - hitCount;
            if (hitCount > 0) {
                this.statsCounter.recordHits(hitCount);
            }
            if (missCount > 0) {
                this.statsCounter.recordMisses(missCount);
            }
            return values;
        }
        return null;
    }

    protected Class<?> getSuffixClass() {
        return this.suffixClass;
    }

    protected String getCacheKey(RuntimeContext context) {
        return this.getCacheKey(this.getSuffixObj(context));
    }

    protected String getCacheKey(Object suffix) {
        return this.prefix + suffix;
    }

    protected Set<String> getCacheKeys(RuntimeContext context) {
        Iterables iterables = new Iterables(this.getSuffixObj(context));
        HashSet<String> keys = new HashSet<String>(iterables.size() * 2);
        for (Object suffix : iterables) {
            String key = this.getCacheKey(suffix);
            keys.add(key);
        }
        return keys;
    }

    protected Object getSuffixObj(RuntimeContext context) {
        return context.getPropertyValue(this.suffixParameterName, this.suffixPropertyPath);
    }

    protected void setSuffixObj(RuntimeContext context, Object obj) {
        context.setPropertyValue(this.suffixParameterName, this.suffixPropertyPath, obj);
    }

    private void init() {
        CacheIgnored cacheIgnoredAnno;
        Class<?> daoClass = this.method.getDeclaringClass();
        Cache cacheAnno = daoClass.getAnnotation(Cache.class);
        if (cacheAnno != null && (cacheIgnoredAnno = this.method.getAnnotation(CacheIgnored.class)) == null) {
            this.useCache = true;
            this.prefix = cacheAnno.prefix();
            this.cacheExpire = Reflection.instantiate(cacheAnno.expire());
            this.expireNum = cacheAnno.num();
            Annotation[][] pass = this.method.getParameterAnnotations();
            int num = 0;
            for (int i = 0; i < pass.length; ++i) {
                Annotation[] pas;
                for (Annotation pa : pas = pass[i]) {
                    if (!CacheBy.class.equals(pa.annotationType())) continue;
                    this.suffixParameterName = this.getParameterNameByIndex(i);
                    this.suffixPropertyPath = ((CacheBy)pa).value();
                    ++num;
                }
            }
            if (num != 1) {
                throw new IncorrectAnnotationException("if use cache, each method expected one and only one cc.concurrent.mango.CacheBy annotation on parameter but found " + num);
            }
            this.checkCacheBy();
            Type suffixType = this.getTypeContext().getPropertyType(this.suffixParameterName, this.suffixPropertyPath);
            TypeToken typeToken = new TypeToken(suffixType);
            this.useMultipleKeys = typeToken.isIterable();
            this.suffixClass = typeToken.getMappedClass();
        }
    }

    private void checkCacheBy() {
        List<ValuableParameter> vps = this.rootNode.getValuableParameters();
        for (ValuableParameter vp : vps) {
            if (!vp.getParameterName().equals(this.suffixParameterName) || !vp.getPropertyPath().equals(this.suffixPropertyPath)) continue;
            return;
        }
        String fullName = this.getFullName(this.suffixParameterName, this.suffixPropertyPath);
        throw new IncorrectCacheByException("CacheBy " + fullName + " can't match any db parameter");
    }

    private String getFullName(String parameterName, String propertyPath) {
        return ":" + (!propertyPath.isEmpty() ? parameterName + "." + propertyPath : parameterName);
    }

    protected void cacheInitPostProcessor() {
    }
}

