/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.operator;

import cc.concurrent.mango.SQL;
import cc.concurrent.mango.exception.IncorrectAnnotationException;
import cc.concurrent.mango.exception.IncorrectReturnTypeException;
import cc.concurrent.mango.exception.IncorrectSqlException;
import cc.concurrent.mango.runtime.operator.BatchUpdateOperator;
import cc.concurrent.mango.runtime.operator.CacheableOperator;
import cc.concurrent.mango.runtime.operator.QueryOperator;
import cc.concurrent.mango.runtime.operator.SQLType;
import cc.concurrent.mango.runtime.operator.UpdateOperator;
import cc.concurrent.mango.runtime.parser.ASTRootNode;
import cc.concurrent.mango.runtime.parser.Parser;
import cc.concurrent.mango.util.Strings;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class OperatorFactory {
    private static final Pattern INSERT_PATTERN = Pattern.compile("^\\s*INSERT\\s+", 2);
    private static final Pattern DELETE_PATTERN = Pattern.compile("^\\s*DELETE\\s+", 2);
    private static final Pattern UPDATE_PATTERN = Pattern.compile("^\\s*UPDATE\\s+", 2);
    private static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*SELECT\\s+", 2);

    public static CacheableOperator getOperator(Method method) throws Exception {
        SQL sqlAnno = method.getAnnotation(SQL.class);
        if (sqlAnno == null) {
            throw new IncorrectAnnotationException("each method expected one cc.concurrent.mango.SQL annotation but not found");
        }
        String sql = sqlAnno.value();
        if (Strings.isNullOrEmpty(sql)) {
            throw new IncorrectSqlException("sql is null or empty");
        }
        ASTRootNode rootNode = new Parser(sql).parse().reduce();
        SQLType sqlType = OperatorFactory.getSQLType(sql);
        Class<?> returnType = method.getReturnType();
        if (sqlType == SQLType.SELECT) {
            return new QueryOperator(rootNode, method, sqlType);
        }
        if (Integer.TYPE.equals(returnType) || Long.TYPE.equals(returnType)) {
            return new UpdateOperator(rootNode, method, sqlType);
        }
        if (int[].class.equals(returnType)) {
            return new BatchUpdateOperator(rootNode, method, sqlType);
        }
        throw new IncorrectReturnTypeException("if sql don't start with select, update return type expected int, batch update return type expected int[], but " + method.getReturnType());
    }

    private static SQLType getSQLType(String sql) {
        if (INSERT_PATTERN.matcher(sql).find()) {
            return SQLType.INSERT;
        }
        if (DELETE_PATTERN.matcher(sql).find()) {
            return SQLType.DELETE;
        }
        if (UPDATE_PATTERN.matcher(sql).find()) {
            return SQLType.UPDATE;
        }
        if (SELECT_PATTERN.matcher(sql).find()) {
            return SQLType.SELECT;
        }
        throw new IncorrectSqlException("sql must start with INSERT or DELETE or UPDATE or SELECT");
    }
}

