/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.operator;

import cc.concurrent.mango.exception.IncorrectReturnTypeException;
import cc.concurrent.mango.exception.IncorrectSqlException;
import cc.concurrent.mango.exception.NotReadablePropertyException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.jdbc.BeanPropertyRowMapper;
import cc.concurrent.mango.jdbc.JdbcUtils;
import cc.concurrent.mango.jdbc.RowMapper;
import cc.concurrent.mango.jdbc.SingleColumnRowMapper;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.operator.CacheableOperator;
import cc.concurrent.mango.runtime.operator.SQLType;
import cc.concurrent.mango.runtime.parser.ASTIterableParameter;
import cc.concurrent.mango.runtime.parser.ASTRootNode;
import cc.concurrent.mango.util.ArrayUtil;
import cc.concurrent.mango.util.Iterables;
import cc.concurrent.mango.util.TypeToken;
import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import cc.concurrent.mango.util.reflect.BeanInfoCache;
import cc.concurrent.mango.util.reflect.BeanUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class QueryOperator
extends CacheableOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(QueryOperator.class);
    private RowMapper<?> rowMapper;
    private boolean isForList;
    private boolean isForSet;
    private boolean isForArray;
    private String interableProperty;

    public QueryOperator(ASTRootNode rootNode, Method method, SQLType sqlType) {
        super(rootNode, method, sqlType);
        this.init();
    }

    private void init() {
        TypeToken typeToken = new TypeToken(this.method.getGenericReturnType());
        this.isForList = typeToken.isList();
        this.isForSet = typeToken.isSet();
        this.isForArray = typeToken.isArray();
        Class<?> mappedClass = typeToken.getMappedClass();
        this.rowMapper = QueryOperator.getRowMapper(mappedClass);
        List<ASTIterableParameter> ips = this.rootNode.getIterableParameters();
        if (!(ips.isEmpty() || this.isForList || this.isForSet || this.isForArray)) {
            throw new IncorrectReturnTypeException("if sql has in clause, return type expected array or implementations of java.util.List or implementations of java.util.Set but " + this.method.getGenericReturnType());
        }
        if (this.isUseCache() && ips.size() == 1) {
            this.interableProperty = ips.get(0).getInterableProperty();
            Method readMethod = BeanInfoCache.getReadMethod(mappedClass, this.interableProperty);
            if (readMethod == null) {
                throw new NotReadablePropertyException("if use cache and sql has one in clause, property " + this.interableProperty + " of " + mappedClass + " expected readable but not");
            }
        }
    }

    @Override
    Type[] getMethodArgTypes(Method method) {
        return method.getGenericParameterTypes();
    }

    @Override
    protected void cacheInitPostProcessor() {
        List<ASTIterableParameter> ips;
        if (this.isUseCache() && (ips = this.rootNode.getIterableParameters()).size() > 1) {
            throw new IncorrectSqlException("if use cache, sql's in clause expected less than or equal 1 but " + ips.size());
        }
    }

    @Override
    public Object execute(Object[] methodArgs) {
        RuntimeContext context = this.buildRuntimeContext(methodArgs);
        if (this.isUseCache()) {
            return this.isUseMultipleKeys() ? this.multipleKeysCache(context, this.rowMapper.getMappedClass(), this.getSuffixClass()) : this.singleKeyCache(context);
        }
        return this.executeFromDb(context);
    }

    private <T, U> Object multipleKeysCache(RuntimeContext context, Class<T> mappedClass, Class<U> suffixClass) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Set<String> keys = this.getCacheKeys(context);
        Map<String, Object> cacheResults = this.getBulkFromCache(keys);
        AddableObject<T> addableObj = new AddableObject<T>(keys.size(), mappedClass);
        int hitCapacity = cacheResults != null ? cacheResults.size() : 0;
        ArrayList<U> hitSuffix = new ArrayList<U>(hitCapacity);
        HashSet<U> missSuffix = new HashSet<U>((keys.size() - hitCapacity) * 2);
        for (Object suffix : new Iterables(this.getSuffixObj(context))) {
            Object value;
            String key = this.getCacheKey(suffix);
            Object object = value = cacheResults != null ? cacheResults.get(key) : null;
            if (value == null) {
                missSuffix.add(suffixClass.cast(suffix));
                continue;
            }
            addableObj.add(mappedClass.cast(value));
            if (!isDebugEnabled) continue;
            hitSuffix.add(suffixClass.cast(suffix));
        }
        if (isDebugEnabled) {
            logger.debug("cache hit #keys={} #values={}", (Object)hitSuffix, (Object)addableObj);
            logger.debug("cache miss #keys={}", (Object)missSuffix);
        }
        if (!missSuffix.isEmpty()) {
            this.setSuffixObj(context, missSuffix);
            Object dbValues = this.executeFromDb(context);
            for (Object dbValue : new Iterables(dbValues)) {
                addableObj.add(mappedClass.cast(dbValue));
                Object suffix = BeanUtil.getPropertyValue(dbValue, this.interableProperty, mappedClass);
                String key = this.getCacheKey(suffix);
                this.setToCache(key, dbValue);
            }
        }
        return addableObj.getReturn();
    }

    private Object singleKeyCache(RuntimeContext context) {
        String key = this.getCacheKey(context);
        Object value = this.getFromCache(key);
        if (value == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("cache miss #key\uff1d{}", (Object)key);
            }
            if ((value = this.executeFromDb(context)) != null) {
                this.setToCache(key, value);
                if (logger.isDebugEnabled()) {
                    logger.debug("cache set #key={} #value={}", (Object)key, value);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("cache hit #key={} #value={}", (Object)key, value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeFromDb(RuntimeContext context) {
        Object r;
        DataSource ds = this.getDataSource(context);
        String sql = this.rootNode.getSql(context);
        Object[] args = this.rootNode.getArgs(context);
        boolean success = false;
        long now = System.nanoTime();
        try {
            r = this.isForList ? this.jdbcTemplate.queryForList(ds, sql, args, this.rowMapper) : (this.isForSet ? this.jdbcTemplate.queryForSet(ds, sql, args, this.rowMapper) : (this.isForArray ? this.jdbcTemplate.queryForArray(ds, sql, args, this.rowMapper) : this.jdbcTemplate.queryForObject(ds, sql, args, this.rowMapper)));
            success = true;
        }
        finally {
            long cost = System.nanoTime() - now;
            if (success) {
                this.statsCounter.recordExecuteSuccess(cost);
            } else {
                this.statsCounter.recordExecuteException(cost);
            }
        }
        return r;
    }

    private static <T> RowMapper<T> getRowMapper(Class<T> clazz) {
        return JdbcUtils.isSingleColumnClass(clazz) ? new SingleColumnRowMapper<T>(clazz) : new BeanPropertyRowMapper<T>(clazz);
    }

    private class AddableObject<T> {
        List<T> hitValueList = null;
        Set<T> hitValueSet = null;
        Class<T> valueClass;

        private AddableObject(int initialCapacity, Class<T> valueClass) {
            if (QueryOperator.this.isForSet) {
                this.hitValueSet = new HashSet<T>(initialCapacity * 2);
            } else {
                this.hitValueList = new ArrayList<T>(initialCapacity);
            }
            this.valueClass = valueClass;
        }

        public void add(T v) {
            if (this.hitValueList != null) {
                this.hitValueList.add(v);
            } else {
                this.hitValueSet.add(v);
            }
        }

        public Object getReturn() {
            if (QueryOperator.this.isForList) {
                return this.hitValueList;
            }
            if (QueryOperator.this.isForSet) {
                return this.hitValueSet;
            }
            if (QueryOperator.this.isForArray) {
                return ArrayUtil.toArray(this.hitValueList, this.valueClass);
            }
            throw new UnreachableCodeException();
        }

        public String toString() {
            return this.hitValueList != null ? this.hitValueList.toString() : this.hitValueSet.toString();
        }
    }
}

