/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.operator;

import cc.concurrent.mango.MethodStats;
import cc.concurrent.mango.runtime.operator.StatsCounter;
import cc.concurrent.mango.util.concurrent.atomic.LongAddable;
import cc.concurrent.mango.util.concurrent.atomic.LongAddables;

public class SimpleStatsCounter
implements StatsCounter {
    private final LongAddable initCount = LongAddables.create();
    private final LongAddable totalInitTime = LongAddables.create();
    private final LongAddable hitCount = LongAddables.create();
    private final LongAddable missCount = LongAddables.create();
    private final LongAddable executeSuccessCount = LongAddables.create();
    private final LongAddable executeExceptionCount = LongAddables.create();
    private final LongAddable totalExecuteTime = LongAddables.create();
    private final LongAddable evictionCount = LongAddables.create();

    @Override
    public void recordInit(long initTime) {
        if (initTime > 0L) {
            this.initCount.increment();
            this.totalInitTime.add(initTime);
        }
    }

    @Override
    public void recordHits(int count) {
        if (count > 0) {
            this.hitCount.add(count);
        }
    }

    @Override
    public void recordMisses(int count) {
        if (count > 0) {
            this.missCount.add(count);
        }
    }

    @Override
    public void recordExecuteSuccess(long executeTime) {
        if (executeTime > 0L) {
            this.executeSuccessCount.increment();
            this.totalExecuteTime.add(executeTime);
        }
    }

    @Override
    public void recordExecuteException(long executeTime) {
        if (executeTime > 0L) {
            this.executeExceptionCount.increment();
            this.totalExecuteTime.add(executeTime);
        }
    }

    @Override
    public void recordEviction(int count) {
        if (count > 0) {
            this.evictionCount.add(count);
        }
    }

    @Override
    public MethodStats snapshot() {
        return new MethodStats(this.initCount.sum(), this.totalInitTime.sum(), this.hitCount.sum(), this.missCount.sum(), this.executeSuccessCount.sum(), this.executeExceptionCount.sum(), this.totalExecuteTime.sum(), this.evictionCount.sum());
    }
}

