/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.operator;

import cc.concurrent.mango.ReturnGeneratedId;
import cc.concurrent.mango.exception.IncorrectSqlException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.jdbc.GeneratedKeyHolder;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.operator.CacheableOperator;
import cc.concurrent.mango.runtime.operator.SQLType;
import cc.concurrent.mango.runtime.parser.ASTIterableParameter;
import cc.concurrent.mango.runtime.parser.ASTRootNode;
import cc.concurrent.mango.util.logging.InternalLogger;
import cc.concurrent.mango.util.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

public class UpdateOperator
extends CacheableOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(UpdateOperator.class);
    private boolean returnGeneratedId;
    private Class<? extends Number> returnType;

    public UpdateOperator(ASTRootNode rootNode, Method method, SQLType sqlType) {
        super(rootNode, method, sqlType);
        this.init();
    }

    void init() {
        ReturnGeneratedId returnGeneratedIdAnno = this.method.getAnnotation(ReturnGeneratedId.class);
        boolean bl = this.returnGeneratedId = returnGeneratedIdAnno != null && this.sqlType == SQLType.INSERT;
        if (Integer.TYPE.equals(this.method.getReturnType())) {
            this.returnType = Integer.TYPE;
        } else if (Long.TYPE.equals(this.method.getReturnType())) {
            this.returnType = Long.TYPE;
        } else {
            throw new UnreachableCodeException();
        }
    }

    @Override
    Type[] getMethodArgTypes(Method method) {
        return method.getGenericParameterTypes();
    }

    @Override
    protected void cacheInitPostProcessor() {
        List<ASTIterableParameter> ips;
        if (this.isUseCache() && (ips = this.rootNode.getIterableParameters()).size() > 1) {
            throw new IncorrectSqlException("if use cache, sql's in clause expected less than or equal 1 but " + ips.size());
        }
    }

    @Override
    public Object execute(Object[] methodArgs) {
        RuntimeContext context = this.buildRuntimeContext(methodArgs);
        DataSource ds = this.getDataSource(context);
        String sql = this.rootNode.getSql(context);
        Object[] args = this.rootNode.getArgs(context);
        Number r = this.executeDb(ds, sql, args);
        if (this.isUseCache()) {
            if (this.isUseMultipleKeys()) {
                Set<String> keys = this.getCacheKeys(context);
                this.deleteFromCache(keys);
                if (logger.isDebugEnabled()) {
                    logger.debug("cache delete #keys={}", (Object)keys);
                }
            } else {
                String key = this.getCacheKey(context);
                this.deleteFromCache(key);
                if (logger.isDebugEnabled()) {
                    logger.debug("cache delete #key={}", (Object)key);
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number executeDb(DataSource ds, String sql, Object[] args) {
        Number r = null;
        long now = System.nanoTime();
        try {
            if (this.returnGeneratedId) {
                GeneratedKeyHolder holder = new GeneratedKeyHolder(this.returnType);
                this.jdbcTemplate.update(ds, sql, args, holder);
                r = holder.getKey();
            } else {
                r = this.jdbcTemplate.update(ds, sql, args);
            }
        }
        finally {
            long cost = System.nanoTime() - now;
            if (r != null) {
                this.statsCounter.recordExecuteSuccess(cost);
            } else {
                this.statsCounter.recordExecuteException(cost);
            }
        }
        return r;
    }
}

