/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.parser;

import cc.concurrent.mango.exception.IncorrectParameterTypeException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.jdbc.JdbcUtils;
import cc.concurrent.mango.runtime.TypeContext;
import cc.concurrent.mango.runtime.parser.Parser;
import cc.concurrent.mango.runtime.parser.ValuableParameter;
import cc.concurrent.mango.util.TypeToken;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ASTIterableParameter
extends ValuableParameter {
    private String interableProperty;

    public ASTIterableParameter(int i) {
        super(i);
    }

    public ASTIterableParameter(Parser p, int i) {
        super(p, i);
    }

    public void setInterableProperty(String interableProperty) {
        this.interableProperty = interableProperty;
    }

    public void setParameter(String parameter) {
        Pattern p = Pattern.compile(":(\\w+)(\\.\\w+)*");
        Matcher m = p.matcher(parameter);
        if (!m.matches()) {
            throw new UnreachableCodeException();
        }
        this.parameterName = m.group(1);
        this.propertyPath = parameter.substring(m.end(1));
        if (!this.propertyPath.isEmpty()) {
            this.propertyPath = this.propertyPath.substring(1);
        }
        this.fullName = parameter;
    }

    public String getInterableProperty() {
        return this.interableProperty;
    }

    @Override
    public void checkType(TypeContext context) {
        Type type = context.getPropertyType(this.parameterName, this.propertyPath);
        TypeToken typeToken = new TypeToken(type);
        Class<?> mappedClass = typeToken.getMappedClass();
        if (!typeToken.isIterable()) {
            throw new IncorrectParameterTypeException("invalid type of " + this.fullName + ", " + "expected array or implementations of java.util.List or implementations of java.util.Set " + "but " + type);
        }
        if (mappedClass == null || !JdbcUtils.isSingleColumnClass(mappedClass)) {
            String s = typeToken.isArray() ? "component" : "actual";
            throw new IncorrectParameterTypeException("invalid " + s + " type of " + this.fullName + ", " + s + " type of " + this.fullName + " expected a class can be identified by jdbc " + "but " + typeToken.getMappedType());
        }
    }

    @Override
    public String toString() {
        return this.interableProperty + " in (" + this.fullName + ")";
    }
}

