/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.parser;

import cc.concurrent.mango.exception.IncorrectParameterTypeException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.jdbc.JdbcUtils;
import cc.concurrent.mango.runtime.TypeContext;
import cc.concurrent.mango.runtime.parser.Parser;
import cc.concurrent.mango.runtime.parser.ValuableParameter;
import cc.concurrent.mango.util.TypeToken;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ASTNonIterableParameter
extends ValuableParameter {
    public ASTNonIterableParameter(int i) {
        super(i);
    }

    public ASTNonIterableParameter(Parser p, int i) {
        super(p, i);
    }

    public void setParameter(String parameter) {
        Pattern p = Pattern.compile(":(\\w+)(\\.\\w+)*");
        Matcher m = p.matcher(parameter);
        if (!m.matches()) {
            throw new UnreachableCodeException();
        }
        this.parameterName = m.group(1);
        this.propertyPath = parameter.substring(m.end(1));
        if (!this.propertyPath.isEmpty()) {
            this.propertyPath = this.propertyPath.substring(1);
        }
        this.fullName = parameter;
    }

    @Override
    public void checkType(TypeContext context) {
        Type type = context.getPropertyType(this.parameterName, this.propertyPath);
        TypeToken typeToken = new TypeToken(type);
        Class<?> mappedClass = typeToken.getMappedClass();
        if (mappedClass == null || typeToken.isIterable() || !JdbcUtils.isSingleColumnClass(mappedClass)) {
            throw new IncorrectParameterTypeException("invalid type of " + this.fullName + ", " + "expected a class can be identified by jdbc but " + type);
        }
    }

    @Override
    public String toString() {
        return this.fullName;
    }
}

