/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.parser;

import cc.concurrent.mango.TablePartition;
import cc.concurrent.mango.exception.IncorrectDefinitionException;
import cc.concurrent.mango.exception.IncorrectSqlException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.TypeContext;
import cc.concurrent.mango.runtime.parser.ASTExpression;
import cc.concurrent.mango.runtime.parser.ASTIterableParameter;
import cc.concurrent.mango.runtime.parser.ASTNonIterableParameter;
import cc.concurrent.mango.runtime.parser.ASTString;
import cc.concurrent.mango.runtime.parser.ASTTable;
import cc.concurrent.mango.runtime.parser.AbstractNode;
import cc.concurrent.mango.runtime.parser.Parser;
import cc.concurrent.mango.runtime.parser.ValuableNode;
import cc.concurrent.mango.runtime.parser.ValuableParameter;
import cc.concurrent.mango.util.Iterables;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class ASTRootNode
extends AbstractNode {
    private AbstractNode head;
    private String staticSql;
    private List<ASTIterableParameter> iterableParameters = new LinkedList<ASTIterableParameter>();
    private List<ValuableParameter> valuableParameters = new LinkedList<ValuableParameter>();
    private ASTTable tableNode;

    public ASTRootNode(int i) {
        super(i);
    }

    public ASTRootNode(Parser p, int i) {
        super(p, i);
    }

    public ASTRootNode reduce() {
        int num = this.jjtGetNumChildren();
        int i = 0;
        AbstractNode prev = null;
        while (i < num) {
            AbstractNode node = (AbstractNode)this.jjtGetChild(i);
            if (prev == null) {
                this.head = node;
            } else {
                prev.next = node;
            }
            prev = node;
            this.handleNode(node);
            if (node instanceof ASTString) {
                StringBuffer sb = new StringBuffer();
                while (node instanceof ASTString) {
                    ASTString str = (ASTString)node;
                    sb.append(str.getValue());
                    if (++i == num) break;
                    node = (AbstractNode)this.jjtGetChild(i);
                }
                ((ASTString)prev).setGroupValue(sb.toString());
                continue;
            }
            ++i;
        }
        return this;
    }

    public void init(@Nullable String table, @Nullable TablePartition tablePartition, @Nullable String shardParameterName, @Nullable String shardPropertyPath) {
        if (this.tableNode != null && table == null) {
            throw new IncorrectDefinitionException("if sql contains #table, @DB.table must define");
        }
        if (this.tableNode == null && table != null) {
            throw new IncorrectDefinitionException("if @DB.table is defined, sql must contain #table");
        }
        if (this.tableNode != null) {
            if (tablePartition == null && shardParameterName == null && shardPropertyPath == null || tablePartition != null && shardParameterName != null && shardPropertyPath != null) {
                this.tableNode.setTable(table);
                this.tableNode.setTablePartition(tablePartition);
                this.tableNode.setShardParameterName(shardParameterName);
                this.tableNode.setShardPpropertyPath(shardPropertyPath);
            } else {
                throw new UnreachableCodeException();
            }
        }
        this.tryBuildSql();
    }

    public void checkType(TypeContext context) {
        AbstractNode node = this.head;
        while (node != null) {
            if (node instanceof ValuableNode) {
                ((ValuableNode)node).checkType(context);
            }
            node = node.next;
        }
    }

    public List<ASTIterableParameter> getIterableParameters() {
        return this.iterableParameters;
    }

    public List<ValuableParameter> getValuableParameters() {
        return this.valuableParameters;
    }

    public String getStaticSql() {
        return this.staticSql;
    }

    public String getSql(RuntimeContext context) {
        if (this.staticSql != null) {
            return this.staticSql;
        }
        StringBuffer sql = new StringBuffer();
        AbstractNode node = this.head;
        while (node != null) {
            if (node instanceof ASTString) {
                ASTString str = (ASTString)node;
                sql.append(str.getGroupValue());
            } else if (node instanceof ASTNonIterableParameter) {
                sql.append("?");
            } else if (node instanceof ASTIterableParameter) {
                ASTIterableParameter aip = (ASTIterableParameter)node;
                sql.append(aip.getInterableProperty()).append(" in (");
                Object objs = aip.value(context);
                if (objs == null) {
                    throw new NullPointerException("value of " + aip.getFullName() + " can't be null");
                }
                Iterables iterables = new Iterables(objs);
                int size = iterables.size();
                if (size == 0) {
                    throw new IllegalArgumentException("value of " + aip.getFullName() + " can't be empty");
                }
                StringBuffer sb = new StringBuffer();
                sb.append("?");
                if (size > 1) {
                    for (int i = 1; i < size; ++i) {
                        sb.append(",?");
                    }
                }
                sql.append(sb).append(")");
            } else if (node instanceof ASTExpression) {
                sql.append(((ASTExpression)node).value(context));
            } else if (node instanceof ASTTable) {
                ASTTable t = (ASTTable)node;
                if (t.needTablePartition()) {
                    sql.append(t.getTable(context));
                } else {
                    sql.append(t.getTable());
                }
            } else {
                throw new UnreachableCodeException();
            }
            node = node.next;
        }
        return sql.toString();
    }

    public Object[] getArgs(RuntimeContext context) {
        LinkedList<Object> args = new LinkedList<Object>();
        for (ValuableParameter node : this.valuableParameters) {
            if (node instanceof ASTNonIterableParameter) {
                ASTNonIterableParameter anip = (ASTNonIterableParameter)node;
                args.add(anip.value(context));
                continue;
            }
            if (!(node instanceof ASTIterableParameter)) continue;
            ASTIterableParameter aip = (ASTIterableParameter)node;
            Object objs = aip.value(context);
            if (objs == null) {
                throw new NullPointerException(aip.getFullName() + " can't be null");
            }
            Iterables iterables = new Iterables(objs);
            int size = iterables.size();
            if (size == 0) {
                throw new IllegalArgumentException(aip.getFullName() + " can't be empty");
            }
            for (Object obj : iterables) {
                args.add(obj);
            }
        }
        return args.toArray();
    }

    private void handleNode(AbstractNode node) {
        if (node instanceof ASTIterableParameter) {
            this.iterableParameters.add((ASTIterableParameter)node);
        }
        if (node instanceof ValuableParameter) {
            this.valuableParameters.add((ValuableParameter)node);
        }
        if (node instanceof ASTTable) {
            if (this.tableNode != null) {
                throw new IncorrectSqlException("too many #table in sql");
            }
            this.tableNode = (ASTTable)node;
        }
    }

    private void tryBuildSql() {
        StringBuffer sb = new StringBuffer();
        AbstractNode node = this.head;
        boolean fail = false;
        while (node != null) {
            if (node instanceof ASTString) {
                ASTString str = (ASTString)node;
                sb.append(str.getGroupValue());
            } else if (node instanceof ASTNonIterableParameter) {
                sb.append("?");
            } else if (node instanceof ASTTable) {
                ASTTable t = (ASTTable)node;
                if (!t.needTablePartition()) {
                    sb.append(t.getTable());
                } else {
                    fail = true;
                }
            } else {
                fail = true;
            }
            if (fail) break;
            node = node.next;
        }
        if (!fail) {
            this.staticSql = sb.toString();
        }
    }
}

