/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.parser;

import cc.concurrent.mango.TablePartition;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.parser.AbstractNode;
import cc.concurrent.mango.runtime.parser.Parser;
import javax.annotation.Nullable;

public class ASTTable
extends AbstractNode {
    private String table;
    private String shardParameterName;
    private String shardPpropertyPath;
    private TablePartition tablePartition;

    public ASTTable(int i) {
        super(i);
    }

    public ASTTable(Parser p, int i) {
        super(p, i);
    }

    String getTable() {
        if (this.needTablePartition()) {
            throw new UnreachableCodeException();
        }
        return this.table;
    }

    String getTable(RuntimeContext context) {
        if (!this.needTablePartition()) {
            throw new UnreachableCodeException();
        }
        Object shardParam = context.getPropertyValue(this.shardParameterName, this.shardPpropertyPath);
        return this.tablePartition.getPartitionedTable(this.table, shardParam);
    }

    boolean needTablePartition() {
        return this.tablePartition != null && this.shardParameterName != null && this.shardPpropertyPath != null;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setShardParameterName(@Nullable String shardParameterName) {
        this.shardParameterName = shardParameterName;
    }

    public void setShardPpropertyPath(@Nullable String shardPpropertyPath) {
        this.shardPpropertyPath = shardPpropertyPath;
    }

    public void setTablePartition(@Nullable TablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

