/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.runtime.parser;

import cc.concurrent.mango.exception.IncorrectParameterTypeException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.runtime.RuntimeContext;
import cc.concurrent.mango.runtime.TypeContext;
import cc.concurrent.mango.runtime.parser.ASTAddExpression;
import cc.concurrent.mango.runtime.parser.ASTExpression;
import cc.concurrent.mango.runtime.parser.Node;
import cc.concurrent.mango.runtime.parser.Parser;
import cc.concurrent.mango.runtime.parser.PrimaryExpression;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ASTVariable
extends PrimaryExpression {
    private String parameterName;
    private String propertyPath;
    private String fullName;

    public ASTVariable(int i) {
        super(i);
    }

    public ASTVariable(Parser p, int i) {
        super(p, i);
    }

    public void setParameter(String parameter) {
        Pattern p = Pattern.compile(":(\\w+)(\\.\\w+)*");
        Matcher m = p.matcher(parameter);
        if (!m.matches()) {
            throw new UnreachableCodeException();
        }
        this.parameterName = m.group(1);
        this.propertyPath = parameter.substring(m.end(1));
        if (!this.propertyPath.isEmpty()) {
            this.propertyPath = this.propertyPath.substring(1);
        }
        this.fullName = parameter;
    }

    @Override
    void checkType(TypeContext context) {
        Type type = context.getPropertyType(this.parameterName, this.propertyPath);
        Node node = this;
        while (!((node = node.jjtGetParent()) instanceof ASTExpression) && node instanceof ASTAddExpression) {
        }
        if (node instanceof ASTExpression) {
            if (!(Integer.class.equals((Object)type) || Integer.TYPE.equals(type) || String.class.equals((Object)type))) {
                throw new IncorrectParameterTypeException("invalid type of " + this.fullName + ", " + "expected int or java.lang.Integer or java.lang.String but " + type);
            }
        } else if (!Integer.class.equals((Object)type) && !Integer.TYPE.equals(type)) {
            throw new IncorrectParameterTypeException("invalid type of " + this.fullName + ", " + "expected int or java.lang.Integer but " + type);
        }
    }

    @Override
    public Object value(RuntimeContext context) {
        return context.getNullablePropertyValue(this.parameterName, this.propertyPath);
    }

    @Override
    public String toString() {
        return this.fullName;
    }
}

