/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class Iterables
implements Iterable {
    private Collection<?> collection = null;
    private Object array = null;
    private Integer size = null;
    private Object object = null;

    public Iterables(Object object) {
        if (Collection.class.isAssignableFrom(object.getClass())) {
            this.collection = (Collection)object;
        } else if (object.getClass().isArray()) {
            this.array = object;
        }
        this.object = object;
    }

    public boolean isIterable() {
        return this.collection != null || this.array != null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        if (this.size == null) {
            if (this.collection != null) {
                this.size = this.collection.size();
            } else if (this.array != null) {
                this.size = Array.getLength(this.array);
            } else {
                throw new IllegalArgumentException("class need collection or array but " + this.object.getClass());
            }
        }
        return this.size;
    }

    public Iterator iterator() {
        if (this.collection != null) {
            return this.collection.iterator();
        }
        if (this.array != null) {
            return new ArrayItr();
        }
        throw new IllegalArgumentException("class need collection or array but " + this.object.getClass());
    }

    private class ArrayItr
    implements Iterator {
        private int cursor = 0;

        private ArrayItr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Iterables.this.size();
        }

        public Object next() {
            return Array.get(Iterables.this.array, this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

