/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public class TypeToken {
    private Class<?> mappedClass = null;
    private Type mappedType = null;
    private boolean isList;
    private boolean isSet;
    private boolean isArray;

    public TypeToken(Type type) {
        if (byte[].class.equals((Object)type)) {
            this.mappedClass = byte[].class;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class rawClass = (Class)rawType;
                if (List.class.equals((Object)rawClass)) {
                    this.isList = true;
                    Type typeArgument = parameterizedType.getActualTypeArguments()[0];
                    if (typeArgument instanceof Class) {
                        this.mappedClass = (Class)typeArgument;
                    }
                    this.mappedType = typeArgument;
                } else if (Set.class.equals((Object)rawClass)) {
                    this.isSet = true;
                    Type typeArgument = parameterizedType.getActualTypeArguments()[0];
                    if (typeArgument instanceof Class) {
                        this.mappedClass = (Class)typeArgument;
                    }
                    this.mappedType = typeArgument;
                }
            }
        } else if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                this.isArray = true;
                this.mappedType = this.mappedClass = clazz.getComponentType();
            } else {
                this.mappedClass = clazz;
            }
        }
    }

    public boolean isIterable() {
        return this.isList || this.isSet || this.isArray;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isCollection() {
        return this.isList || this.isSet;
    }

    public Class<?> getMappedClass() {
        return this.mappedClass;
    }

    public Type getMappedType() {
        return this.mappedType;
    }
}

