/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.util.reflect;

import cc.concurrent.mango.util.concurrent.CacheLoader;
import cc.concurrent.mango.util.concurrent.DoubleCheckCache;
import cc.concurrent.mango.util.concurrent.LoadingCache;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanInfoCache {
    private static final LoadingCache<Class<?>, BeanInfo> cache = new DoubleCheckCache(new CacheLoader<Class<?>, BeanInfo>(){

        @Override
        public BeanInfo load(Class<?> clazz) throws Exception {
            return new BeanInfo(clazz);
        }
    });

    public static Method getReadMethod(Class<?> clazz, String propertyName) {
        return cache.getUnchecked(clazz).getReadMethod(propertyName);
    }

    public static Method getWriteMethod(Class<?> clazz, String propertyName) {
        return cache.getUnchecked(clazz).getWriteMethod(propertyName);
    }

    public static List<PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        return cache.getUnchecked(clazz).getPropertyDescriptors();
    }

    private static class BeanInfo {
        final List<PropertyDescriptor> propertyDescriptors;
        final Map<String, Method> readMethodMap;
        final Map<String, Method> writeMethodMap;

        public BeanInfo(Class<?> clazz) throws Exception {
            HashMap<String, Method> rmm = new HashMap<String, Method>();
            HashMap<String, Method> wmm = new HashMap<String, Method>();
            ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
            java.beans.BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Method writeMethod;
                pds.add(pd);
                String name = pd.getName();
                Method readMethod = pd.getReadMethod();
                if (readMethod != null) {
                    rmm.put(name, readMethod);
                }
                if ((writeMethod = pd.getWriteMethod()) == null) continue;
                wmm.put(name, writeMethod);
            }
            this.propertyDescriptors = Collections.unmodifiableList(pds);
            this.readMethodMap = Collections.unmodifiableMap(rmm);
            this.writeMethodMap = Collections.unmodifiableMap(wmm);
        }

        public Method getReadMethod(String propertyName) {
            return this.readMethodMap.get(propertyName);
        }

        public Method getWriteMethod(String propertyName) {
            return this.writeMethodMap.get(propertyName);
        }

        public List<PropertyDescriptor> getPropertyDescriptors() {
            return this.propertyDescriptors;
        }
    }
}

