/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.util.reflect;

import cc.concurrent.mango.exception.UncheckedException;
import cc.concurrent.mango.util.reflect.BeanInfoCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class BeanUtil {
    public static void setPropertyValue(Object object, String propertyPath, Object value) {
        try {
            Class<?> rootClass = object.getClass();
            int pos = propertyPath.indexOf(46);
            StringBuffer nestedPath = new StringBuffer(propertyPath.length());
            int t = 0;
            while (pos > -1) {
                if (object == null) {
                    throw new NullPointerException(BeanUtil.getErrorMessage(nestedPath.toString(), rootClass));
                }
                String propertyName = propertyPath.substring(0, pos);
                if (t != 0) {
                    nestedPath.append(".");
                }
                nestedPath.append(propertyName);
                Method method = BeanInfoCache.getWriteMethod(object.getClass(), propertyName);
                object = method.invoke(object, (Object[])null);
                propertyPath = propertyPath.substring(pos + 1);
                pos = propertyPath.indexOf(46);
                ++t;
            }
            if (object == null) {
                throw new NullPointerException(BeanUtil.getErrorMessage(nestedPath.toString(), rootClass));
            }
            Method method = BeanInfoCache.getWriteMethod(object.getClass(), propertyPath);
            method.invoke(object, value);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
    }

    public static Object getPropertyValue(@Nullable Object object, String propertyPath, Object useForException) {
        Object value = BeanUtil.getNullablePropertyValue(object, propertyPath, useForException);
        if (value == null) {
            throw new NullPointerException(BeanUtil.getErrorMessage(propertyPath, useForException));
        }
        return value;
    }

    @Nullable
    public static Object getNullablePropertyValue(@Nullable Object object, String propertyPath, Object useForException) {
        try {
            Object value = object;
            int pos = propertyPath.indexOf(46);
            StringBuffer nestedPath = new StringBuffer(propertyPath.length());
            int t = 0;
            while (pos > -1) {
                if (value == null) {
                    throw new NullPointerException(BeanUtil.getErrorMessage(nestedPath.toString(), useForException));
                }
                String propertyName = propertyPath.substring(0, pos);
                if (t != 0) {
                    nestedPath.append(".");
                }
                nestedPath.append(propertyName);
                Method method = BeanInfoCache.getReadMethod(value.getClass(), propertyName);
                value = method.invoke(value, (Object[])null);
                propertyPath = propertyPath.substring(pos + 1);
                pos = propertyPath.indexOf(46);
                ++t;
            }
            if (value == null) {
                throw new NullPointerException(BeanUtil.getErrorMessage(nestedPath.toString(), useForException));
            }
            Method method = BeanInfoCache.getReadMethod(value.getClass(), propertyPath);
            value = method.invoke(value, (Object[])null);
            return value;
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
    }

    private static String getErrorMessage(String nestedPath, Object useForException) {
        if (useForException instanceof String) {
            String parameterName = (String)useForException;
            if (nestedPath.isEmpty()) {
                return "parameter ':" + parameterName + "' is null";
            }
            return "property ':" + parameterName + "." + nestedPath + "' is null";
        }
        if (useForException instanceof Class) {
            Class clazz = (Class)useForException;
            return "property " + nestedPath + " of " + clazz + " is null, please check return type";
        }
        throw new IllegalArgumentException("useForException's type expected Class or String but " + useForException.getClass());
    }
}

