/*
 * Decompiled with CFR 0.152.
 */
package cc.concurrent.mango.util.reflect;

import cc.concurrent.mango.exception.NotReadablePropertyException;
import cc.concurrent.mango.exception.UnreachableCodeException;
import cc.concurrent.mango.util.Strings;
import cc.concurrent.mango.util.reflect.BeanInfoCache;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeUtil {
    public static Type getPropertyType(Type type, String parameterName, String propertyPath) {
        Method method;
        if (Strings.isNullOrEmpty(propertyPath)) {
            throw new UnreachableCodeException();
        }
        int pos = propertyPath.indexOf(46);
        StringBuffer parentPath = new StringBuffer(propertyPath.length());
        while (pos > -1) {
            Method method2;
            String propertyName = propertyPath.substring(0, pos);
            Class<?> clazz = TypeUtil.getClassFromType(type);
            if (clazz != null && (method2 = BeanInfoCache.getReadMethod(clazz, propertyName)) != null) {
                type = method2.getGenericReturnType();
                propertyPath = propertyPath.substring(pos + 1);
                pos = propertyPath.indexOf(46);
                TypeUtil.appendParentPath(parentPath, propertyName);
                continue;
            }
            String parentFullName = TypeUtil.getFullName(parameterName, parentPath.toString());
            TypeUtil.appendParentPath(parentPath, propertyName);
            String fullName = TypeUtil.getFullName(parameterName, parentPath.toString());
            throw new NotReadablePropertyException("property " + fullName + " is not readable, " + "the type of " + parentFullName + " is " + type + ", please check it's get method");
        }
        Class<?> clazz = TypeUtil.getClassFromType(type);
        if (clazz != null && (method = BeanInfoCache.getReadMethod(clazz, propertyPath)) != null) {
            type = method.getGenericReturnType();
            return type;
        }
        String parentFullName = TypeUtil.getFullName(parameterName, parentPath.toString());
        TypeUtil.appendParentPath(parentPath, propertyPath);
        String fullName = TypeUtil.getFullName(parameterName, parentPath.toString());
        throw new NotReadablePropertyException("property " + fullName + " is not readable, " + "the type of " + parentFullName + " is " + type + ", please check it's get method");
    }

    private static Class<?> getClassFromType(Type type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        }
        return clazz;
    }

    private static void appendParentPath(StringBuffer parentPath, String propertyName) {
        if (parentPath.length() == 0) {
            parentPath.append(propertyName);
        } else {
            parentPath.append(".").append(propertyName);
        }
    }

    private static String getFullName(String parameterName, String propertyPath) {
        return ":" + (!propertyPath.isEmpty() ? parameterName + "." + propertyPath : parameterName);
    }
}

