/*
 * Decompiled with CFR 0.152.
 */
package cc.ddrpa.chaparral;

import cc.ddrpa.chaparral.annotation.Sensitive;
import cc.ddrpa.chaparral.desensitizer.DesensitizerFactory;
import cc.ddrpa.chaparral.desensitizer.IDesensitizer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;

public class DesensitizeSerializer
extends StdSerializer<Object>
implements ContextualSerializer {
    private IDesensitizer desensitizer;

    public IDesensitizer getDesensitizer() {
        return this.desensitizer;
    }

    public void setDesensitizer(IDesensitizer desensitizer) {
        this.desensitizer = desensitizer;
    }

    protected DesensitizeSerializer() {
        super(Object.class);
    }

    protected DesensitizeSerializer(Class<Object> t) {
        super(t);
    }

    protected DesensitizeSerializer(JavaType type) {
        super(type);
    }

    protected DesensitizeSerializer(Class<?> t, boolean dummy) {
        super(t, dummy);
    }

    protected DesensitizeSerializer(StdSerializer<?> src) {
        super(src);
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        IDesensitizer desensitizer = this.getDesensitizer();
        if (Objects.nonNull(desensitizer)) {
            try {
                gen.writeObject(desensitizer.desensitize(value));
            }
            catch (Exception e) {
                gen.writeString("******");
            }
        } else if (value instanceof String) {
            gen.writeString("******");
        } else {
            gen.writeObject(value);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Sensitive annotation;
        if (Objects.nonNull(property) && Objects.nonNull(annotation = (Sensitive)property.getAnnotation(Sensitive.class))) {
            DesensitizeSerializer serializer = new DesensitizeSerializer(Object.class);
            serializer.setDesensitizer(DesensitizerFactory.getDesensitizer(annotation.strategy(), annotation.using()));
            return serializer;
        }
        return prov.findNullValueSerializer(property);
    }
}

