/*
 * Decompiled with CFR 0.152.
 */
package cc.imorning.silk;

import android.util.Log;
import cc.imorning.silk.AudioConfig;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0004J \u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012H\u0082 J!\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012H\u0082 J\t\u0010\u0017\u001a\u00020\u0004H\u0082 R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcc/imorning/silk/SilkJni;", "", "()V", "pcmSuffix", "", "getPcmSuffix", "()Ljava/lang/String;", "silkSuffix", "getSilkSuffix", "decode", "", "silkFilePath", "pcmFilePath", "audioSampleRate", "Lcc/imorning/silk/AudioConfig$AudioSampleRate;", "encode", "getVersion", "nativeDecode", "", "input", "output", "sampleRate", "nativeEncode", "nativeGetSilkVersion", "Companion", "InnerClass", "silk_release"})
public class SilkJni {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pcmSuffix;
    @NotNull
    private final String silkSuffix;
    @NotNull
    private static final String TAG = "SilkJni";

    public SilkJni() {
        this.pcmSuffix = "pcm";
        this.silkSuffix = "silk";
        System.loadLibrary("silk");
    }

    private final native String nativeGetSilkVersion();

    private final native int nativeEncode(String var1, String var2, int var3);

    private final native int nativeDecode(String var1, String var2, int var3);

    @NotNull
    public final String getPcmSuffix() {
        return this.pcmSuffix;
    }

    @NotNull
    public final String getSilkSuffix() {
        return this.silkSuffix;
    }

    @NotNull
    public final String getVersion() {
        return this.nativeGetSilkVersion();
    }

    protected final void encode(@NotNull String pcmFilePath, @NotNull String silkFilePath, @NotNull AudioConfig.AudioSampleRate audioSampleRate) {
        Intrinsics.checkNotNullParameter((Object)pcmFilePath, (String)"pcmFilePath");
        Intrinsics.checkNotNullParameter((Object)silkFilePath, (String)"silkFilePath");
        Intrinsics.checkNotNullParameter((Object)((Object)audioSampleRate), (String)"audioSampleRate");
        File inputFile = new File(pcmFilePath);
        if (inputFile.exists()) {
            this.nativeEncode(pcmFilePath, silkFilePath, audioSampleRate.getRate());
        } else {
            Log.e((String)TAG, (String)("encode failed,file " + pcmFilePath + " not exist"));
        }
    }

    protected final void decode(@NotNull String silkFilePath, @NotNull String pcmFilePath, @NotNull AudioConfig.AudioSampleRate audioSampleRate) {
        Intrinsics.checkNotNullParameter((Object)silkFilePath, (String)"silkFilePath");
        Intrinsics.checkNotNullParameter((Object)pcmFilePath, (String)"pcmFilePath");
        Intrinsics.checkNotNullParameter((Object)((Object)audioSampleRate), (String)"audioSampleRate");
        File inputFile = new File(silkFilePath);
        if (inputFile.exists()) {
            String output = pcmFilePath;
            if (((CharSequence)pcmFilePath).length() == 0) {
                String string = new File(StringsKt.replace$default((String)silkFilePath, (String)this.silkSuffix, (String)this.pcmSuffix, (boolean)false, (int)4, null)).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(silkFilePath.replac\u2026 pcmSuffix)).absolutePath");
                output = string;
            }
            this.nativeDecode(silkFilePath, output, audioSampleRate.getRate());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcc/imorning/silk/SilkJni$Companion;", "", "()V", "TAG", "", "getInstance", "Lcc/imorning/silk/SilkJni;", "silk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SilkJni getInstance() {
            return InnerClass.INSTANCE.getSilkJni();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcc/imorning/silk/SilkJni$InnerClass;", "", "()V", "silkJni", "Lcc/imorning/silk/SilkJni;", "getSilkJni", "()Lcc/imorning/silk/SilkJni;", "silk_release"})
    private static final class InnerClass {
        @NotNull
        public static final InnerClass INSTANCE = new InnerClass();
        @NotNull
        private static final SilkJni silkJni = new SilkJni();

        private InnerClass() {
        }

        @NotNull
        public final SilkJni getSilkJni() {
            return silkJni;
        }
    }
}

