/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.jwt.model;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Payload {
    private static final String[] ARR = new String[]{"iss", "exp", "sub", "aud", "nbf", "iat", "jti"};
    private static final Set<String> PREDEFINED = new HashSet<String>(Arrays.asList(ARR));
    private Map<String, Object> content;

    public Payload(Map<String, Object> content) {
        this.content = content;
    }

    public Payload() {
        this(new HashMap<String, Object>());
    }

    public Object get(String key) {
        return this.content.get(key);
    }

    public Payload set(String key, Object val) {
        if (PREDEFINED.contains(key)) {
            throw new RuntimeException("Key can not in predefined");
        }
        return this.set0(key, val);
    }

    private Payload set0(String key, Object val) {
        this.content.put(key, val);
        return this;
    }

    public String getIss() {
        return (String)this.get("iss");
    }

    public Payload setIss(String iss) {
        return this.set0("iss", iss);
    }

    public Date getExp() {
        Object date = this.get("exp");
        if (date == null) {
            return null;
        }
        return new Date((Long)date);
    }

    public Payload setExp(Date exp) {
        return this.set0("exp", exp);
    }

    public String getSub() {
        return (String)this.get("sub");
    }

    public Payload setSub(String sub) {
        return this.set0("sub", sub);
    }

    public String getAud() {
        return (String)this.get("aud");
    }

    public Payload setAud(String aud) {
        return this.set0("aud", aud);
    }

    public Date getNbf() {
        Object date = this.get("nbf");
        if (date == null) {
            return null;
        }
        return new Date((Long)date);
    }

    public Payload setNbf(Date nbf) {
        return this.set0("nbf", nbf);
    }

    public Date getIat() {
        Object date = this.get("iat");
        if (date == null) {
            return null;
        }
        return new Date((Long)date);
    }

    public Payload setIat(Date iat) {
        return this.set0("iat", iat);
    }

    public String getJti() {
        return (String)this.get("jti");
    }

    public Payload setJti(String jti) {
        return this.set0("jti", jti);
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public void setContent(Map<String, Object> content) {
        this.content = content;
    }
}

