/*
 * Decompiled with CFR 0.152.
 */
package cc.kkon.jwt.utils;

import java.util.Arrays;

public class GMUtils {
    public static byte[] SM3(byte[] message) {
        byte[] paddedMsg = GMUtils.messagePadding(message);
        return GMUtils.iterativeCompression(paddedMsg);
    }

    public static byte[] HmacSM3(byte[] message, byte[] key) {
        int LENGTH = 64;
        int zeroLength = 64 - key.length;
        byte[] zero = new byte[zeroLength];
        for (int i = 0; i < zeroLength; ++i) {
            zero[i] = 0;
        }
        byte[] actualKey = key.length > 64 ? GMUtils.SM3(key) : GMUtils.bytesMerge(key, zero);
        byte[] iPadXOR = new byte[64];
        byte[] oPadXOR = new byte[64];
        for (int i = 0; i < 64; ++i) {
            iPadXOR[i] = (byte)(actualKey[i] ^ 0x36);
            oPadXOR[i] = (byte)(actualKey[i] ^ 0x5C);
        }
        byte[] firstMerge = GMUtils.bytesMerge(iPadXOR, message);
        byte[] firstHash = GMUtils.SM3(firstMerge);
        byte[] secondMerge = GMUtils.bytesMerge(oPadXOR, firstHash);
        return GMUtils.SM3(secondMerge);
    }

    private static byte[] messagePadding(byte[] msg) {
        long keyLength = msg.length;
        byte[] BIT = new byte[]{-128};
        int outKeyLength = (int)(keyLength % 64L);
        int zeroLength = outKeyLength < 55 ? 55 - outKeyLength : 55 - outKeyLength + 64;
        byte[] binaryMessageLength = GMUtils.longToBytes(keyLength * 8L);
        byte[] zero = new byte[zeroLength];
        for (int i = 0; i < zeroLength; ++i) {
            zero[i] = 0;
        }
        return GMUtils.bytesMerge(GMUtils.bytesMerge(GMUtils.bytesMerge(msg, BIT), zero), binaryMessageLength);
    }

    private static int[][] extendMessage(int[] word) {
        int j;
        int[][] result = new int[2][];
        int[] w = new int[68];
        int[] w1 = new int[64];
        for (int i = 0; i < word.length; ++i) {
            w[i] = word[i];
        }
        for (j = 16; j <= 67; ++j) {
            w[j] = GMUtils.P1(w[j - 16] ^ w[j - 9] ^ GMUtils.CircleLeftShift(w[j - 3], 15)) ^ GMUtils.CircleLeftShift(w[j - 13], 7) ^ w[j - 6];
        }
        for (j = 0; j <= 63; ++j) {
            w1[j] = w[j] ^ w[j + 4];
        }
        result[0] = w;
        result[1] = w1;
        return result;
    }

    private static byte[] iterativeCompression(byte[] paddedMsg) {
        int[] word = new int[16];
        int n = paddedMsg.length / 64;
        int[] VI = new int[]{1937774191, 1226093241, 388252375, -628488704, -1452330820, 372324522, -477237683, -1325724082};
        int[] VX = new int[8];
        for (int i = 0; i < n; ++i) {
            try {
                byte[] bytes = Arrays.copyOfRange(paddedMsg, 64 * i, 64 * (i + 1));
                for (int j = 0; j < 16; ++j) {
                    word[j] = GMUtils.bytesToWord(bytes, j * 4);
                }
                VI = GMUtils.CF(VI, word);
                VX = VI;
                continue;
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        return GMUtils.wordsToBytes(VX);
    }

    private static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = (7 - i) * 8;
            bytes[i] = (byte)(num >>> offset & 0xFFL);
        }
        return bytes;
    }

    private static byte[] wordsToBytes(int[] words) {
        byte[] bytes = new byte[32];
        for (int i = 0; i < words.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                int offset = (3 - j) * 8;
                bytes[j + i * 4] = (byte)(words[i] >>> offset & 0xFF);
            }
        }
        return bytes;
    }

    private static int bytesToWord(byte[] bytes, int index) {
        int result = (bytes[index] & 0xFF) << 24 | (bytes[index + 1] & 0xFF) << 16 | (bytes[index + 2] & 0xFF) << 8 | bytes[index + 3] & 0xFF;
        return result;
    }

    private static byte[] bytesMerge(byte[] front, byte[] rear) {
        byte[] bytes = Arrays.copyOf(front, front.length + rear.length);
        System.arraycopy(rear, 0, bytes, front.length, rear.length);
        return bytes;
    }

    private static int[] CF(int[] VI, int[] word) {
        int[][] wx = GMUtils.extendMessage(word);
        int[] w = wx[0];
        int[] w1 = wx[1];
        int[] result = new int[8];
        int A = VI[0];
        int B = VI[1];
        int C = VI[2];
        int D = VI[3];
        int E = VI[4];
        int F = VI[5];
        int G = VI[6];
        int H = VI[7];
        for (int j = 0; j <= 63; ++j) {
            int SS1 = GMUtils.CircleLeftShift(GMUtils.CircleLeftShift(A, 12) + E + GMUtils.CircleLeftShift(GMUtils.T(j), j), 7);
            int SS2 = SS1 ^ GMUtils.CircleLeftShift(A, 12);
            int TT1 = GMUtils.FF(A, B, C, j) + D + SS2 + w1[j];
            int TT2 = GMUtils.GG(E, F, G, j) + H + SS1 + w[j];
            D = C;
            C = GMUtils.CircleLeftShift(B, 9);
            B = A;
            A = TT1;
            H = G;
            G = GMUtils.CircleLeftShift(F, 19);
            F = E;
            E = GMUtils.P0(TT2);
        }
        result[0] = A ^ VI[0];
        result[1] = B ^ VI[1];
        result[2] = C ^ VI[2];
        result[3] = D ^ VI[3];
        result[4] = E ^ VI[4];
        result[5] = F ^ VI[5];
        result[6] = G ^ VI[6];
        result[7] = H ^ VI[7];
        return result;
    }

    private static int T(int j) {
        if (j <= 15) {
            return 2043430169;
        }
        return 2055708042;
    }

    private static int FF(int x, int y, int z, int j) {
        int result = 0;
        if (j >= 0 && j <= 15) {
            result = x ^ y ^ z;
        } else if (j >= 16 && j <= 63) {
            result = x & y | x & z | y & z;
        }
        return result;
    }

    private static int GG(int x, int y, int z, int j) {
        int result = 0;
        if (j >= 0 && j <= 15) {
            result = x ^ y ^ z;
        } else if (j >= 16 && j <= 63) {
            result = x & y | ~x & z;
        }
        return result;
    }

    private static int CircleLeftShift(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private static int P0(int x) {
        return x ^ GMUtils.CircleLeftShift(x, 9) ^ GMUtils.CircleLeftShift(x, 17);
    }

    private static int P1(int x) {
        return x ^ GMUtils.CircleLeftShift(x, 15) ^ GMUtils.CircleLeftShift(x, 23);
    }
}

