/*
 * Decompiled with CFR 0.152.
 */
package cc.stacks.devkit;

import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.net.URLCodec;

public class Security {
    private static Base32 base32 = new Base32();
    private static URLCodec urlCodec = new URLCodec();

    public static String stringToHex(String Text) {
        byte[] bs;
        char[] chars = "0123456789ABCDEF".toCharArray();
        StringBuilder Hex = new StringBuilder();
        for (byte b : bs = Text.getBytes()) {
            int bit = (b & 0xF0) >> 4;
            Hex.append(chars[bit]);
            bit = b & 0xF;
            Hex.append(chars[bit]);
        }
        return Hex.toString().trim();
    }

    public static String hexToString(String Hex) {
        String str = "0123456789ABCDEF";
        char[] hexs = Hex.toCharArray();
        byte[] bytes = new byte[Hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = str.indexOf(hexs[2 * i]) * 16;
            bytes[i] = (byte)((n += str.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return new String(bytes);
    }

    public static String MDDigest(boolean Reduction, String Text) {
        if (Reduction) {
            return DigestUtils.md2Hex((String)Text);
        }
        return DigestUtils.md5Hex((String)Text);
    }

    public static String SHADigest(int Level2, String Text) {
        if (Level2 == 1) {
            return DigestUtils.sha1Hex((String)Text);
        }
        if (Level2 == 256) {
            return DigestUtils.sha256Hex((String)Text);
        }
        if (Level2 == 384) {
            return DigestUtils.sha384Hex((String)Text);
        }
        if (Level2 == 512) {
            return DigestUtils.sha512Hex((String)Text);
        }
        return DigestUtils.sha1Hex((String)Text);
    }

    public static String UnicodeEncode(String Text) {
        StringBuilder Unicode = new StringBuilder();
        for (char Char : Text.toCharArray()) {
            Unicode.append("\\u").append(Integer.toHexString(Char));
        }
        return Unicode.toString();
    }

    public static String UnicodeDecode(String Code) {
        StringBuilder Unicode = new StringBuilder();
        String[] Hex = Code.split("\\\\u");
        for (int i = 1; i < Hex.length; ++i) {
            int data = Integer.parseInt(Hex[i], 16);
            Unicode.append((char)data);
        }
        return Unicode.toString();
    }

    public static String URLCodeEncode(String Text) {
        try {
            return urlCodec.encode(Text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String URLCodeDecode(String Code) {
        try {
            return urlCodec.decode(Code);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String Base32Encode(String Text) {
        byte[] EncodeBytes = base32.encode(Text.getBytes());
        return new String(EncodeBytes);
    }

    public static String Base32Decode(String Code) {
        byte[] DecodeBytes = base32.decode(Code.getBytes());
        return new String(DecodeBytes);
    }

    public static String Base64Encode(String Text) {
        byte[] EncodeBytes = Base64.getEncoder().encode(Text.getBytes());
        return new String(EncodeBytes);
    }

    public static String Base64Decode(String Code) {
        byte[] DecodeBytes = Base64.getDecoder().decode(Code.getBytes());
        return new String(DecodeBytes);
    }

    public static String SymmetricKeyGenerator(String Type, int Long2) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(Type);
            keyGenerator.init(Long2);
            SecretKey SecretKey2 = keyGenerator.generateKey();
            return Hex.encodeHexString((byte[])SecretKey2.getEncoded());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String SymmetricEncode(String Type, String Message2, String Key2) {
        try {
            Cipher cipher = Cipher.getInstance(Type + "/ECB/PKCS5Padding");
            if (Type.equals("DES")) {
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(Type);
                DESKeySpec DesKeySpec = new DESKeySpec(Hex.decodeHex((char[])Key2.toCharArray()));
                cipher.init(1, secretKeyFactory.generateSecret(DesKeySpec));
            } else if (Type.equals("AES")) {
                cipher.init(1, new SecretKeySpec(Hex.decodeHex((char[])Key2.toCharArray()), "AES"));
            }
            byte[] resultBytes = cipher.doFinal(Message2.getBytes());
            return Hex.encodeHexString((byte[])resultBytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String SymmetricDecode(String Type, String Message2, String Key2) {
        try {
            Cipher cipher = Cipher.getInstance(Type + "/ECB/PKCS5Padding");
            if (Type.equals("DES")) {
                DESKeySpec DesKeySpec = new DESKeySpec(Hex.decodeHex((char[])Key2.toCharArray()));
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(Type);
                cipher.init(2, secretKeyFactory.generateSecret(DesKeySpec));
            } else if (Type.equals("AES")) {
                cipher.init(2, new SecretKeySpec(Hex.decodeHex((char[])Key2.toCharArray()), "AES"));
            }
            byte[] result = Hex.decodeHex((char[])Message2.toCharArray());
            return new String(cipher.doFinal(result));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String TOTPKeyGenerator() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(Security.Base64Decode("g8GjEvTbW5oVSV7avLBdwIHqGlUYNzKFI7izOF8GwLDVKs2m0QN7vxRs2im5MDaNCWGmcD2rvcZx").getBytes());
            byte[] buffer = secureRandom.generateSeed(10);
            Base32 codec = new Base32();
            return new String(codec.encode(buffer));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean TOTPVerification(String Code, String Key2, int Offset) {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(Key2);
        long Time = System.currentTimeMillis() / 1000L / 30L;
        for (int i = -1; i <= Offset; ++i) {
            String hash;
            try {
                hash = Security.TOTPCalculation(decodedKey, Time + (long)i);
            }
            catch (Exception e) {
                return false;
            }
            if (!hash.equals(Code)) continue;
            return true;
        }
        return false;
    }

    public static String TOTPCodeGenerator(String Key2) {
        try {
            Base32 codec = new Base32();
            byte[] decodedKey = codec.decode(Key2);
            long Time = System.currentTimeMillis() / 1000L / 30L;
            return Security.TOTPCalculation(decodedKey, Time);
        }
        catch (Exception e) {
            return "000000";
        }
    }

    private static String TOTPCalculation(byte[] Key2, long Time) {
        try {
            byte[] data = new byte[8];
            long value = Time;
            int i = 8;
            while (i-- > 0) {
                data[i] = (byte)value;
                value >>>= 8;
            }
            SecretKeySpec signKey = new SecretKeySpec(Key2, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signKey);
            byte[] hash = mac.doFinal(data);
            int offset = hash[19] & 0xF;
            long LongCode = 0L;
            for (int i2 = 0; i2 < 4; ++i2) {
                LongCode <<= 8;
                LongCode |= (long)(hash[offset + i2] & 0xFF);
            }
            LongCode &= Integer.MAX_VALUE;
            String Code = String.valueOf(LongCode %= 1000000L);
            if (Code.length() >= 6) {
                return Code;
            }
            StringBuffer CodeBuffer = new StringBuffer(Code);
            for (int i3 = 0; i3 < 6 - Code.length(); ++i3) {
                CodeBuffer.insert(0, "0");
            }
            return CodeBuffer.toString();
        }
        catch (Exception e) {
            return "000000";
        }
    }
}

