/*
 * Decompiled with CFR 0.152.
 */
package cc.stacks.devkit;

import cc.stacks.devkit.Security;
import com.google.gson.Gson;

public class Token<T> {
    private T Data;
    private long Time;
    private int Invalid;
    private String Type;

    public Token(T Data, int Invalid, String Type) {
        this.Data = Data;
        this.Invalid = Invalid;
        this.Type = Type;
    }

    public T getData() {
        return this.Data;
    }

    public void setData(T data) {
        this.Data = data;
    }

    public long getTime() {
        return this.Time;
    }

    public void setTime(long time) {
        this.Time = time;
    }

    public int getInvalid() {
        return this.Invalid;
    }

    public void setInvalid(int invalid) {
        this.Invalid = invalid;
    }

    public String getType() {
        return this.Type;
    }

    public void setType(String type) {
        this.Type = type;
    }

    public String Issuance(String Key2) {
        try {
            this.Time = System.currentTimeMillis();
            Gson gson = new Gson();
            String AESCode = Security.SymmetricEncode("AES", gson.toJson((Object)this), Key2);
            return Security.Base64Encode(AESCode + "." + Security.MDDigest(false, AESCode));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Token Analysis(String Code, String Key2) {
        try {
            Gson gson = new Gson();
            String Base64Code = Security.Base64Decode(Code);
            String AESCode = Base64Code.substring(0, Base64Code.indexOf("."));
            String Md5Code = Base64Code.substring(Base64Code.indexOf(".") + 1);
            if (Security.MDDigest(false, AESCode).equals(Md5Code)) {
                Token token = (Token)gson.fromJson(Security.SymmetricDecode("AES", AESCode, Key2), Token.class);
                if (token.Time + (long)token.Invalid > System.currentTimeMillis()) {
                    return token;
                }
                token.setData(null);
                return token;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

